/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class HostVipBaseAction
extends Action {
    private final List<Vip> successVips = new LinkedList<Vip>();
    private Vip failedVip;

    protected final Result processVips(WorkItem workItem) {
        List<Vip> vips = this.dataAccess.getVips(workItem.getService().serviceId);
        if (vips == null || vips.isEmpty()) {
            return Result.success;
        }
        Result result = Result.success;
        for (Vip vip : vips) {
            if (!vip.getModuleId().equals(workItem.getMainModule().moduleId) || !vip.getEnvironment().equals(workItem.getHost().environment)) continue;
            result = this.processVip(workItem, vip);
            if (result == Result.error) {
                this.failedVip = vip;
                this.dataAccess.updateSatus(workItem.getHost().hostId, false, "Failed to " + this.getVerb() + " host " + this.getPreposition() + " VIP");
                return result;
            }
            this.successVips.add(vip);
        }
        return result;
    }

    protected abstract Result processVip(WorkItem var1, Vip var2);

    @Override
    public void recordAudit(WorkItem workItem, Result result, Map<String, String> notes, String output) {
        if (this.successVips == null || this.successVips.isEmpty()) {
            output = this.failedVip == null ? "No VIPs to " + this.getVerb() : "Failed to " + this.getVerb() + " host " + this.getPreposition() + " VIP " + this.failedVip.getDns();
        } else {
            output = "VIPs successfully " + this.getVerbPastTense() + ":\n";
            for (Vip vip : this.successVips) {
                output = output + " - " + vip.getDns() + "\n";
            }
            if (this.failedVip != null) {
                output = "Failed to " + this.getVerb() + " host " + this.getPreposition() + " VIP " + this.failedVip.getDns();
            }
        }
        this.writeAudit(workItem, result, notes, output);
    }

    protected abstract String getVerb();

    protected abstract String getVerbPastTense();

    protected abstract String getPreposition();
}

