/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem.action;

import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import com.northernwall.hadrian.workItem.dao.SmokeTestData;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostSmokeTestAction
extends Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostSmokeTestAction.class);
    private String smokeTestOutput = null;

    @Override
    public void updateStatus(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being smoke tested", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, true, "Smoke Testing...");
    }

    @Override
    public Result process(WorkItem workItem) {
        Result result;
        String smokeTestUrl = workItem.getMainModule().smokeTestUrl;
        if (smokeTestUrl == null || smokeTestUrl.isEmpty()) {
            return Result.success;
        }
        SmokeTestData smokeTestData = this.smokeTestHelper.ExecuteSmokeTest(smokeTestUrl, workItem.getHost().hostName, workItem.getService().serviceName, "action");
        if (smokeTestData == null) {
            result = Result.error;
        } else if (smokeTestData.result == null || smokeTestData.result.isEmpty() || !smokeTestData.result.equalsIgnoreCase("PASS")) {
            result = Result.error;
            this.smokeTestOutput = smokeTestData.output;
        } else {
            result = Result.success;
            this.smokeTestOutput = smokeTestData.output;
        }
        return result;
    }

    @Override
    public void success(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being smoke tested", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(host.getHostId(), false, "-");
    }

    @Override
    public void error(WorkItem workItem) {
        Host host = this.dataAccess.getHost(workItem.getService().serviceId, workItem.getHost().hostId);
        if (host == null) {
            LOGGER.warn("Could not find host {} being smoke tested", (Object)workItem.getHost().hostId);
            return;
        }
        this.dataAccess.updateSatus(workItem.getHost().hostId, false, "Last smoke test failed");
    }

    @Override
    public void recordAudit(WorkItem workItem, Result result, Map<String, String> notes, String output) {
        this.writeAudit(workItem, result, notes, this.smokeTestOutput);
    }
}

