/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.workItem.Result;
import com.northernwall.hadrian.workItem.action.Action;
import com.northernwall.hadrian.workItem.action.HostCreateAction;
import com.northernwall.hadrian.workItem.action.HostDeleteAction;
import com.northernwall.hadrian.workItem.action.HostDeployAction;
import com.northernwall.hadrian.workItem.action.HostRestartAction;
import com.northernwall.hadrian.workItem.action.HostSmokeTestAction;
import com.northernwall.hadrian.workItem.action.HostVipAddAction;
import com.northernwall.hadrian.workItem.action.HostVipDisableAction;
import com.northernwall.hadrian.workItem.action.HostVipEnableAction;
import com.northernwall.hadrian.workItem.action.HostVipRemoveAction;
import com.northernwall.hadrian.workItem.action.ModuleCreateAction;
import com.northernwall.hadrian.workItem.action.ModuleDeleteAction;
import com.northernwall.hadrian.workItem.action.ModuleUpdateAction;
import com.northernwall.hadrian.workItem.action.ServiceCreateAction;
import com.northernwall.hadrian.workItem.action.ServiceDeleteAction;
import com.northernwall.hadrian.workItem.action.ServiceTransferAction;
import com.northernwall.hadrian.workItem.action.ServiceUpdateAction;
import com.northernwall.hadrian.workItem.action.VipCreateAction;
import com.northernwall.hadrian.workItem.action.VipDeleteAction;
import com.northernwall.hadrian.workItem.action.VipMigrateAction;
import com.northernwall.hadrian.workItem.action.VipUpdateAction;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import com.northernwall.hadrian.workItem.helper.SmokeTestHelper;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.dshops.metrics.MetricRegistry;
import org.dshops.metrics.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkItemProcessor.class);
    private final Parameters parameters;
    private final ConfigHelper configHelper;
    private final DataAccess dataAccess;
    private final OkHttpClient client;
    private final Gson gson;
    private final SmokeTestHelper smokeTestHelper;
    private final MetricRegistry metricRegistry;
    private final ExecutorService executor;

    public WorkItemProcessor(Parameters parameters, ConfigHelper configHelper, DataAccess dataAccess, OkHttpClient client, Gson gson, SmokeTestHelper smokeTestHelper, MetricRegistry metricRegistry) {
        this.parameters = parameters;
        this.configHelper = configHelper;
        this.dataAccess = dataAccess;
        this.client = client;
        this.gson = gson;
        this.smokeTestHelper = smokeTestHelper;
        this.metricRegistry = metricRegistry;
        this.constructAction("serviceCreate", ServiceCreateAction.class);
        this.constructAction("serviceUpdate", ServiceUpdateAction.class);
        this.constructAction("serviceTransfer", ServiceTransferAction.class);
        this.constructAction("serviceDelete", ServiceDeleteAction.class);
        this.constructAction("moduleCreate", ModuleCreateAction.class);
        this.constructAction("moduleUpdate", ModuleUpdateAction.class);
        this.constructAction("moduleDelete", ModuleDeleteAction.class);
        this.constructAction("hostCreate", HostCreateAction.class);
        this.constructAction("hostDeploy", HostDeployAction.class);
        this.constructAction("hostRestart", HostRestartAction.class);
        this.constructAction("hostSmokeTest", HostSmokeTestAction.class);
        this.constructAction("hostDelete", HostDeleteAction.class);
        this.constructAction("vipCreate", VipCreateAction.class);
        this.constructAction("vipUpdate", VipUpdateAction.class);
        this.constructAction("vipDelete", VipDeleteAction.class);
        this.constructAction("vipMigrate", VipMigrateAction.class);
        this.constructAction("hostVipEnable", HostVipEnableAction.class);
        this.constructAction("hostVipDisable", HostVipDisableAction.class);
        this.constructAction("hostVipAdd", HostVipAddAction.class);
        this.constructAction("hostVipRemove", HostVipRemoveAction.class);
        this.executor = Executors.newFixedThreadPool(10);
    }

    public void processWorkItem(WorkItem workItem) throws IOException {
        if (workItem == null) {
            return;
        }
        workItem.setNextId(null);
        this.dataAccess.saveWorkItem(workItem);
        this.executor.submit(() -> this.process(workItem));
    }

    public void processWorkItems(List<WorkItem> workItems) throws IOException {
        if (workItems == null || workItems.isEmpty()) {
            return;
        }
        if (workItems.size() == 1) {
            this.processWorkItem(workItems.get(0));
            return;
        }
        int size = workItems.size();
        for (int i = 0; i < size; ++i) {
            WorkItem workItem = workItems.get(i);
            if (i == size - 1) {
                workItem.setNextId(null);
            } else {
                workItem.setNextId(workItems.get(i + 1).getId());
            }
            this.dataAccess.saveWorkItem(workItem);
        }
        this.executor.submit(() -> this.process((WorkItem)workItems.get(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(WorkItem workItem) {
        Action action = this.getAction(workItem);
        Result result = Result.error;
        Timer timer = this.metricRegistry.timer("action.duration", new String[]{"action", action.getName()});
        try {
            action.updateStatus(workItem);
            result = action.process(workItem);
        }
        catch (Exception e) {
            try {
                LOGGER.warn("Failure while performing action {}, {}", (Object)action.getName(), (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                timer.stop(new String[]{"result", result.toString()});
                throw throwable;
            }
            timer.stop(new String[]{"result", result.toString()});
        }
        timer.stop(new String[]{"result", result.toString()});
        switch (result) {
            case success: {
                action.success(workItem);
                action.recordAudit(workItem, result, new HashMap<String, String>(), null);
                LOGGER.info("Work item {} has been successfully processed, no callback expected. {}", (Object)action.getName(), (Object)workItem.getId());
                this.dataAccess.deleteWorkItem(workItem.getId());
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 200);
                this.startNext(workItem);
                break;
            }
            case error: {
                action.error(workItem);
                action.recordAudit(workItem, result, new HashMap<String, String>(), null);
                LOGGER.warn("Work item {} failed to be process, no callback expected. {}", (Object)action.getName(), (Object)workItem.getId());
                this.dataAccess.deleteWorkItem(workItem.getId());
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 502);
                this.stopNext(workItem);
                break;
            }
            case wip: {
                LOGGER.info("Work item {} is being processed, waiting for callback. {}", (Object)action.getName(), (Object)workItem.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCallback(CallbackData callbackData) {
        WorkItem workItem = this.dataAccess.getWorkItem(callbackData.requestId);
        Action action = this.getAction(workItem);
        Result result = Result.error;
        Timer timer = this.metricRegistry.timer("action.callbackDuration", new String[]{"action", action.getName()});
        try {
            result = action.processCallback(workItem, callbackData);
        }
        catch (Exception e) {
            try {
                LOGGER.warn("Failure while performing action calback {}, {}", (Object)action.getName(), (Object)e.getMessage());
            }
            catch (Throwable throwable) {
                timer.stop(new String[]{"result", result.toString()});
                throw throwable;
            }
            timer.stop(new String[]{"result", result.toString()});
        }
        timer.stop(new String[]{"result", result.toString()});
        switch (result) {
            case success: {
                action.success(workItem);
                action.recordAudit(workItem, result, this.createNotesFromCallback(callbackData), callbackData.output);
                LOGGER.info("Work item {} has been successfully processed. {}", (Object)action.getName(), (Object)workItem.getId());
                this.dataAccess.deleteWorkItem(workItem.getId());
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 200);
                this.startNext(workItem);
                break;
            }
            case error: {
                action.error(workItem);
                action.recordAudit(workItem, result, this.createNotesFromCallback(callbackData), callbackData.output);
                LOGGER.warn("Work item {} failed to be process. {}", (Object)action.getName(), (Object)workItem.getId());
                this.dataAccess.deleteWorkItem(workItem.getId());
                this.dataAccess.saveWorkItemStatus(workItem.getId(), 502);
                this.stopNext(workItem);
                break;
            }
            case wip: {
                LOGGER.info("Work item {} is still being processed. {}", (Object)action.getName(), (Object)workItem.getId());
            }
        }
    }

    private Map<String, String> createNotesFromCallback(CallbackData callbackData) {
        HashMap<String, String> notes = new HashMap<String, String>();
        if (callbackData != null) {
            if (callbackData.errorCode != 0) {
                notes.put("error_code", Integer.toString(callbackData.errorCode));
            }
            if (callbackData.errorDescription != null && !callbackData.errorDescription.isEmpty()) {
                notes.put("error_desc", callbackData.errorDescription);
            }
        }
        return notes;
    }

    public int waitForProcess(String lastId, long step, long max, String note) {
        LOGGER.info("Waiting for deployment, {}", (Object)note);
        long total = 0L;
        while (total < max) {
            int workItemStatus;
            total += step;
            try {
                Thread.sleep(step);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((workItemStatus = this.dataAccess.getWorkItemStatus(lastId)) <= 0) continue;
            LOGGER.info("Waiting done, status {}, {}", (Object)workItemStatus, (Object)note);
            return workItemStatus;
        }
        LOGGER.warn("Done waiting, but work items are not done, {}", (Object)note);
        return 500;
    }

    private Action getAction(WorkItem workItem) {
        switch (workItem.getType()) {
            case service: {
                switch (workItem.getOperation()) {
                    case create: {
                        return this.constructAction("serviceCreate", ServiceCreateAction.class);
                    }
                    case update: {
                        return this.constructAction("serviceUpdate", ServiceUpdateAction.class);
                    }
                    case transfer: {
                        return this.constructAction("serviceTransfer", ServiceUpdateAction.class);
                    }
                    case delete: {
                        return this.constructAction("serviceDelete", ServiceDeleteAction.class);
                    }
                }
            }
            case module: {
                switch (workItem.getOperation()) {
                    case create: {
                        return this.constructAction("moduleCreate", ModuleCreateAction.class);
                    }
                    case update: {
                        return this.constructAction("moduleUpdate", ModuleUpdateAction.class);
                    }
                    case delete: {
                        return this.constructAction("moduleDelete", ModuleDeleteAction.class);
                    }
                }
            }
            case host: {
                switch (workItem.getOperation()) {
                    case create: {
                        return this.constructAction("hostCreate", HostCreateAction.class);
                    }
                    case deploy: {
                        return this.constructAction("hostDeploy", HostDeployAction.class);
                    }
                    case restart: {
                        return this.constructAction("hostRestart", HostRestartAction.class);
                    }
                    case enableVips: {
                        return this.constructAction("hostVipEnable", HostVipEnableAction.class);
                    }
                    case disableVips: {
                        return this.constructAction("hostVipDisable", HostVipDisableAction.class);
                    }
                    case addVips: {
                        return this.constructAction("hostVipAdd", HostVipAddAction.class);
                    }
                    case removeVips: {
                        return this.constructAction("hostVipRemove", HostVipRemoveAction.class);
                    }
                    case smokeTest: {
                        return this.constructAction("hostSmokeTest", HostSmokeTestAction.class);
                    }
                    case delete: {
                        return this.constructAction("hostDelete", HostDeleteAction.class);
                    }
                }
            }
            case vip: {
                switch (workItem.getOperation()) {
                    case create: {
                        return this.constructAction("vipCreate", VipCreateAction.class);
                    }
                    case update: {
                        return this.constructAction("vipUpdate", VipUpdateAction.class);
                    }
                    case delete: {
                        return this.constructAction("vipDelete", VipDeleteAction.class);
                    }
                    case migrate: {
                        return this.constructAction("vipMigrate", VipMigrateAction.class);
                    }
                }
            }
        }
        throw new RuntimeException("Unknown work item - " + (Object)((Object)workItem.getType()) + " " + (Object)((Object)workItem.getOperation()));
    }

    private Action constructAction(String name, Class defaultClass) {
        String factoryName = this.parameters.getString("action." + name, null);
        try {
            Class<?> c;
            if (factoryName != null && !factoryName.isEmpty()) {
                c = Class.forName(factoryName);
            } else {
                c = defaultClass;
                factoryName = defaultClass.getName();
            }
            Action action = (Action)c.newInstance();
            action.init(name, this.dataAccess, this.parameters, this.configHelper, this.client, this.gson, this.smokeTestHelper);
            LOGGER.info("Constructed action {} with {}", (Object)name, (Object)factoryName);
            return action;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Could not build Action " + name + ", could not find class " + factoryName, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Could not build Action " + name + ", could not instantiation class " + factoryName, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Could not build Action " + name + ", could not access class " + factoryName, ex);
        }
    }

    private void startNext(WorkItem workItem) {
        String nextId = workItem.getNextId();
        if (nextId == null || nextId.isEmpty()) {
            LOGGER.info("Start next {} -> Done", (Object)workItem.getId());
            if (workItem.getType() == Type.host) {
                this.dataAccess.updateSatus(workItem.getHost().hostId, false, "-");
            }
            return;
        }
        LOGGER.info("Start next {} -> {}", (Object)workItem.getId(), (Object)nextId);
        WorkItem nextWorkItem = this.dataAccess.getWorkItem(nextId);
        if (workItem.getType() == Type.host && !workItem.getHost().hostId.equals(nextWorkItem.getHost().hostId)) {
            this.dataAccess.updateSatus(workItem.getHost().hostId, false, "-");
        }
        this.process(nextWorkItem);
    }

    private void stopNext(WorkItem workItem) {
        String nextId = workItem.getNextId();
        if (nextId == null || nextId.isEmpty()) {
            LOGGER.info("Stop next {} -> Done", (Object)workItem.getId());
            return;
        }
        LOGGER.info("Stop next {} -> {}", (Object)workItem.getId(), (Object)nextId);
        WorkItem nextWorkItem = this.dataAccess.getWorkItem(nextId);
        this.stopNext(nextWorkItem);
        if (workItem.getType() == Type.host && !workItem.getHost().hostId.equals(nextWorkItem.getHost().hostId)) {
            this.dataAccess.updateSatus(nextWorkItem.getHost().hostId, false, "Queued operation cancelled");
        }
        this.dataAccess.deleteWorkItem(nextId);
        this.dataAccess.saveWorkItemStatus(nextId, 502);
    }
}

