/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.workItem;

import com.google.gson.Gson;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.northernwall.hadrian.workItem.dao.CallbackData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkItemCallbackHandler
extends BasicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkItemCallbackHandler.class);
    private final WorkItemProcessor workItemProcessor;

    public WorkItemCallbackHandler(Gson gson, WorkItemProcessor workItemProcessor) {
        super(null, gson);
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        CallbackData data = this.fromJson(request, CallbackData.class);
        LOGGER.info("Received {} callback {}", (Object)data.status, (Object)data.requestId);
        this.workItemProcessor.processCallback(data);
        response.setStatus(200);
        request.setHandled(true);
    }
}

