/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.schedule;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.utility.HealthWriter;
import com.northernwall.hadrian.messaging.MessagingCoodinator;
import com.northernwall.hadrian.schedule.Leader;
import com.northernwall.hadrian.schedule.MetricsRunner;
import com.northernwall.hadrian.schedule.SmokeTestRunner;
import com.northernwall.hadrian.workItem.helper.SmokeTestHelper;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.dshops.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleRunner
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleRunner.class);
    private static final CronParser CRON_PARSER = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX));
    private static final String METRICS_CRON = "15 4 * * *";
    private final int group;
    private final DataAccess dataAccess;
    private final MetricRegistry metricRegistry;
    private final Leader leader;
    private final SmokeTestHelper smokeTestHelper;
    private final MessagingCoodinator messagingCoodinator;
    private final ScheduledExecutorService scheduledExecutorService;
    private ZonedDateTime prevChecked;

    public static Cron parseCron(String cronExpression) {
        return CRON_PARSER.parse(cronExpression);
    }

    public ScheduleRunner(int group, DataAccess dataAccess, MetricRegistry metricRegistry, Leader leader, SmokeTestHelper smokeTestHelper, MessagingCoodinator messagingCoodinator, ScheduledExecutorService scheduledExecutorService) {
        this.group = group;
        this.dataAccess = dataAccess;
        this.metricRegistry = metricRegistry;
        this.leader = leader;
        this.smokeTestHelper = smokeTestHelper;
        this.messagingCoodinator = messagingCoodinator;
        this.scheduledExecutorService = scheduledExecutorService;
        this.prevChecked = ZonedDateTime.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ZonedDateTime now = ZonedDateTime.now();
        boolean doMetrics = this.checkCron(METRICS_CRON, now);
        try {
            if (this.leader.isLeader(this.group)) {
                this.processGroup(now, doMetrics);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception during running group {}, {}", (Object)this.group, (Object)e.getMessage());
        }
        finally {
            this.prevChecked = now;
        }
    }

    private void processGroup(ZonedDateTime now, boolean doMetrics) {
        int serviceCount = 0;
        int smokeTestCount = 0;
        List<Service> services = this.dataAccess.getActiveServices();
        for (Service service : services) {
            int serviceGroup = Math.abs(service.getServiceId().hashCode() % 10);
            if (serviceGroup != this.group) continue;
            ++serviceCount;
            List<Module> modules = this.dataAccess.getModules(service.getServiceId());
            if (modules != null && !modules.isEmpty()) {
                LOGGER.info("Processing {} with {} modules", (Object)service.getServiceName(), (Object)modules.size());
                for (Module module : modules) {
                    LOGGER.info("Processing {} {} with type {}", new Object[]{module.getModuleName(), service.getServiceName(), module.getModuleType()});
                    if (module.getModuleType() != ModuleType.Deployable) continue;
                    String smokeTestCron = module.getSmokeTestCron();
                    String smokeTestUrl = module.getSmokeTestUrl();
                    LOGGER.info("Processing {} {} with '{}' {}", new Object[]{module.getModuleName(), service.getServiceName(), smokeTestCron, smokeTestUrl});
                    if (smokeTestUrl == null || smokeTestUrl.isEmpty() || smokeTestCron == null || smokeTestCron.isEmpty() || !this.checkCron(smokeTestCron, now)) continue;
                    ++smokeTestCount;
                    this.scheduledExecutorService.submit(new SmokeTestRunner(service, module, this.group, this.dataAccess, this.smokeTestHelper, this.messagingCoodinator));
                }
            } else {
                LOGGER.info("Processing {} with no modules", (Object)service.getServiceName());
            }
            if (!doMetrics) continue;
            this.scheduledExecutorService.submit(new MetricsRunner(service, this.group, this.dataAccess, this.metricRegistry));
        }
        LOGGER.info("Run schedule for group {}, service count {}, smoke test count {}", new Object[]{this.group, serviceCount, smokeTestCount});
    }

    private boolean checkCron(String cronExpression, ZonedDateTime now) {
        try {
            if (cronExpression == null || cronExpression.isEmpty()) {
                return false;
            }
            Cron cron = ScheduleRunner.parseCron(cronExpression);
            ExecutionTime executionTime = ExecutionTime.forCron((Cron)cron);
            ZonedDateTime last = executionTime.lastExecution(now);
            boolean b1 = last.isAfter(this.prevChecked);
            boolean b2 = last.isBefore(now);
            LOGGER.info("cron={} now={} last={} prevCheck={} b1={} b2={}", new Object[]{cronExpression, now.toString(), last.toString(), this.prevChecked.toString(), b1, b2});
            return b1 && b2;
        }
        catch (Exception e) {
            LOGGER.error("Check cron '{}' failed, {}", (Object)cronExpression, (Object)e.getMessage());
            return false;
        }
    }

    public void getHealth(HealthWriter writer) throws IOException {
        if (this.leader.isLeader(this.group)) {
            writer.addStringLine("Schedule Runner " + this.group, "Leader");
        } else {
            writer.addStringLine("Schedule Runner " + this.group, "Not leader");
        }
    }
}

