/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.schedule;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.schedule.HostCounter;
import java.util.LinkedList;
import java.util.List;
import org.dshops.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsRunner
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsRunner.class);
    private final Service service;
    private final int group;
    private final DataAccess dataAccess;
    private final MetricRegistry metricRegistry;

    public MetricsRunner(Service service, int group, DataAccess dataAccess, MetricRegistry metricRegistry) {
        this.service = service;
        this.group = group;
        this.dataAccess = dataAccess;
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void run() {
        LOGGER.info("Running scheduled metrics for {} in group {}", (Object)this.service.getServiceName(), (Object)this.group);
        LinkedList<HostCounter> hostCounters = new LinkedList<HostCounter>();
        List<Host> hosts = this.dataAccess.getHosts(this.service.getServiceId());
        Team team = this.dataAccess.getTeam(this.service.getTeamId());
        if (hosts != null && !hosts.isEmpty()) {
            for (Host host : hosts) {
                HostCounter hostCounter = this.find(hostCounters, host);
                ++hostCounter.count;
            }
        }
        if (!hostCounters.isEmpty()) {
            for (HostCounter hostCounter : hostCounters) {
                this.metricRegistry.event("host-count", hostCounter.count, new String[]{"metricTeam", team.getTeamName(), "metricService", this.service.getServiceName(), "metricDataCenter", hostCounter.dataCenter, "metricEnvironment", hostCounter.environment, "metricPlatform", hostCounter.platform});
            }
        }
    }

    private HostCounter find(List<HostCounter> hostCounters, Host host) {
        if (!hostCounters.isEmpty()) {
            for (HostCounter hostCounter : hostCounters) {
                if (!hostCounter.dataCenter.equals(host.getDataCenter()) || !hostCounter.environment.equals(host.getEnvironment()) || !hostCounter.platform.equals(host.getPlatform())) continue;
                return hostCounter;
            }
        }
        HostCounter hostCounter = new HostCounter();
        hostCounter.dataCenter = host.getDataCenter();
        hostCounter.environment = host.getEnvironment();
        hostCounter.platform = host.getPlatform();
        hostCounters.add(hostCounter);
        return hostCounter;
    }
}

