/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.messaging.slack;

import com.google.gson.Gson;
import com.northernwall.hadrian.Const;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.messaging.MessageProcessor;
import com.northernwall.hadrian.messaging.MessageType;
import com.northernwall.hadrian.messaging.slack.SlackMessage;
import com.northernwall.hadrian.parameters.Parameters;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackMessageProcessor
extends MessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlackMessageProcessor.class);
    private Gson gson;
    private OkHttpClient client;
    private String slackUrl;
    private String slackUser;

    @Override
    public void init(Parameters parameters, Gson gson, OkHttpClient client) {
        this.gson = gson;
        this.client = client;
        this.slackUrl = parameters.getString("slackUrl", null);
        this.slackUser = parameters.getString("slackUser", "Hadrian");
    }

    @Override
    public void process(MessageType messageType, Team team, Map<String, String> data) {
        if (messageType == null || messageType.slackBody == null || messageType.slackBody.isEmpty() || this.slackUrl == null || this.slackUrl.isEmpty() || team.getTeamSlack() == null || team.getTeamSlack().isEmpty()) {
            return;
        }
        SlackMessage msg = new SlackMessage();
        msg.channel = team.getTeamSlack();
        msg.username = this.slackUser;
        msg.text = this.replaceTerms(messageType.slackBody, data);
        msg.icon_emoji = messageType.slackIcon;
        RequestBody body = RequestBody.create((MediaType)Const.JSON_MEDIA_TYPE, (String)this.gson.toJson((Object)msg));
        Request request = new Request.Builder().url(this.slackUrl).post(body).build();
        try {
            Response response = this.client.newCall(request).execute();
            LOGGER.info("{} {} {}", new Object[]{response.isSuccessful(), response.code(), response.body().string()});
            response.body().close();
        }
        catch (IOException e) {
            LOGGER.error("Exception which contacting Slack", (Throwable)e);
        }
    }
}

