/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.vip;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.vip.dao.PostVipData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class VipCreateHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public VipCreateHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, WorkItemProcessor workItemProcessor) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostVipData data = this.fromJson(request, PostVipData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, team, "add a vip");
        List<Vip> vips = this.getDataAccess().getVips(data.serviceId);
        for (Vip temp : vips) {
            if (!temp.getDns().equals(data.dns) || !temp.getDomain().equals(data.domain) || temp.getVipPort() != data.vipPort) continue;
            return;
        }
        Module module = this.getModule(data.moduleId, null, service);
        Vip vip = new Vip(data.serviceId, "Creating...", data.moduleId, data.dns, data.domain, data.external, data.environment, data.protocol, data.vipPort, data.servicePort);
        vip.setMigration(2);
        this.getDataAccess().saveVip(vip);
        WorkItem workItem = new WorkItem(Type.vip, Operation.create, user, team, service, module, null, vip, null);
        this.workItemProcessor.processWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

