/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.utility;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dshops.metrics.MetricRegistry;
import org.dshops.metrics.Timer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerList;

public class MetricHandler
extends AbstractHandler {
    private final HandlerList handlers;
    private final MetricRegistry metricRegistry;

    public MetricHandler(HandlerList handlers, MetricRegistry metricRegistry) {
        this.handlers = handlers;
        this.metricRegistry = metricRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Timer timer = null;
        if (!(target.equals("/availability") || target.equals("/version") || target.startsWith("/ui/"))) {
            timer = this.metricRegistry.timer("http.duration", new String[]{"url", target, "method", request.getMethod()});
        }
        try {
            this.handlers.handle(target, request, httpRequest, response);
            if (timer == null) return;
        }
        catch (Throwable throwable) {
            if (timer == null) throw throwable;
            timer.stop(new String[]{"status", Integer.toString(response.getStatus())});
            throw throwable;
        }
        timer.stop(new String[]{"status", Integer.toString(response.getStatus())});
    }

    public void setServer(Server server) {
        super.setServer(server);
        this.handlers.setServer(server);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.handlers.stop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.handlers.start();
    }
}

