/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.utility;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Date;

public class HealthWriter {
    private final OutputStream stream;

    public HealthWriter(OutputStream stream) {
        this.stream = stream;
    }

    private void writeln(String text) throws IOException {
        this.stream.write(text.getBytes());
    }

    public void open() throws IOException {
        this.writeln("<html>");
        this.writeln("<body>");
        this.writeln("<table>");
    }

    public void close() throws IOException {
        this.writeln("</table>");
        this.writeln("</body>");
        this.writeln("</html>");
        this.stream.close();
    }

    public void addStringLine(String label, String value) throws IOException {
        if (value == null) {
            this.writeln("<tr><td>" + label + "</td><td>-- NULL --</td></tr>");
        } else if (value.isEmpty()) {
            this.writeln("<tr><td>" + label + "</td><td>-- EMPTY --</td></tr>");
        } else {
            this.writeln("<tr><td>" + label + "</td><td>" + value + "</td></tr>");
        }
    }

    public void addDateTimeLine(String label, OffsetDateTime value) throws IOException {
        if (value == null) {
            this.addStringLine(label, null);
        } else {
            this.addStringLine(label, value.toString() + " or " + value.atZoneSameInstant(ZoneId.of("UTC")).toString());
        }
    }

    public void addDateLine(String label, Date value) throws IOException {
        if (value == null) {
            this.addStringLine(label, null);
        } else {
            this.addStringLine(label, new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ").format(value));
        }
    }

    public void addIntLine(String label, int value) throws IOException {
        this.addStringLine(label, Integer.toString(value));
    }

    void addClassLine(String label, Object value) throws IOException {
        if (value == null) {
            this.addStringLine(label, null);
        } else {
            this.addStringLine(label, value.getClass().getCanonicalName());
        }
    }
}

