/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.utility;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleFile;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http400BadRequestException;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertHandler
extends BasicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertHandler.class);
    private final AccessHelper accessHelper;
    private final ConfigHelper configHelper;

    public ConvertHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, ConfigHelper configHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        this.accessHelper.checkIfUserIsAdmin(request, "convert attribute");
        String attribute = request.getParameter("attr");
        String oldValue = request.getParameter("old");
        String newValue = request.getParameter("new");
        if (attribute == null || attribute.isEmpty()) {
            throw new Http400BadRequestException("Parameter 'attr' is missing");
        }
        if (oldValue == null || oldValue.isEmpty()) {
            throw new Http400BadRequestException("Parameter 'old' is missing");
        }
        if (newValue == null || newValue.isEmpty()) {
            throw new Http400BadRequestException("Parameter 'new' is missing");
        }
        if (attribute.equalsIgnoreCase("environment")) {
            if (!this.configHelper.getConfig().environmentNames.contains(newValue)) {
                throw new Http400BadRequestException("New Value is not a legal Environment");
            }
            LOGGER.info("Converting Environment value {} to {}", (Object)oldValue, (Object)newValue);
            this.convertEnvironment(oldValue, newValue);
        } else if (attribute.equalsIgnoreCase("platform")) {
            if (!this.configHelper.getConfig().platforms.contains(newValue)) {
                throw new Http400BadRequestException("New Value is not a legal Platform");
            }
            LOGGER.info("Converting Platform value {} to {}", (Object)oldValue, (Object)newValue);
            this.convertPlatform(oldValue, newValue);
        } else {
            throw new Http400BadRequestException("Parameter 'attr' is unknown");
        }
        response.setStatus(200);
        request.setHandled(true);
    }

    private void convertEnvironment(String oldValue, String newValue) {
        List<Service> services = this.getDataAccess().getActiveServices();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                List<Vip> list;
                List<Host> hosts;
                List<Module> modules = this.getDataAccess().getModules(service.getServiceId());
                if (modules != null && !modules.isEmpty()) {
                    for (Module module : modules) {
                        List<ModuleFile> moduleFiles;
                        if (module.getEnvironmentNames() != null && !module.getEnvironmentNames().isEmpty() && module.getEnvironmentNames().containsKey(oldValue)) {
                            boolean value = module.getEnvironmentNames().get(oldValue);
                            LOGGER.info("Found a module with '{}' environment, {} in {} with value {}", new Object[]{oldValue, module.getModuleName(), service.getServiceName(), value});
                            module.getEnvironmentNames().put(newValue, value);
                            module.getEnvironmentNames().remove(oldValue);
                            this.getDataAccess().saveModule(module);
                        }
                        if ((moduleFiles = this.getDataAccess().getModuleFiles(service.getServiceId(), module.getModuleId(), oldValue)) == null || moduleFiles.isEmpty()) continue;
                        for (ModuleFile moduleFile : moduleFiles) {
                            LOGGER.info("Found a module file with '{}' environment, {} in {}", new Object[]{oldValue, module.getModuleName(), service.getServiceName()});
                            moduleFile.setEnvironment(newValue);
                            this.getDataAccess().saveModuleFile(moduleFile);
                            this.getDataAccess().deleteModuleFile(service.getServiceId(), module.getModuleId(), oldValue, moduleFile.getName());
                        }
                    }
                }
                if ((hosts = this.getDataAccess().getHosts(service.getServiceId())) != null && !hosts.isEmpty()) {
                    for (Host host : hosts) {
                        if (!host.getEnvironment().equals(oldValue)) continue;
                        LOGGER.info("Found a host with '{}' environment, {} in {}", new Object[]{oldValue, host.getHostName(), service.getServiceName()});
                        host.setEnvironment(newValue);
                        this.getDataAccess().updateHost(host);
                    }
                }
                if ((list = this.getDataAccess().getVips(service.getServiceId())) == null || list.isEmpty()) continue;
                for (Vip vip : list) {
                    if (!vip.getEnvironment().equals(oldValue)) continue;
                    LOGGER.info("Found a VIP with '{}' environment, {} in {}", new Object[]{oldValue, vip.getDns(), service.getServiceName()});
                    vip.setEnvironment(newValue);
                    this.getDataAccess().saveVip(vip);
                }
            }
        }
    }

    private void convertPlatform(String oldValue, String newValue) {
        List<Service> services = this.getDataAccess().getActiveServices();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
                if (hosts == null || hosts.isEmpty()) continue;
                for (Host host : hosts) {
                    if (!host.getPlatform().equals(oldValue)) continue;
                    LOGGER.info("Found a host with '{}' environment, {} in {}", new Object[]{oldValue, host.getHostName(), service.getServiceName()});
                    host.setPlatform(newValue);
                    this.getDataAccess().updateHost(host);
                }
            }
        }
    }
}

