/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.tree;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.tree.dao.TreeData;
import com.northernwall.hadrian.handlers.tree.dao.TreeServiceData;
import com.northernwall.hadrian.handlers.tree.dao.TreeTeamData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class TreeHandler
extends AbstractHandler {
    private final DataAccess dataAccess;
    private final AccessHelper accessHelper;
    private final Gson gson;

    public TreeHandler(DataAccess dataAccess, AccessHelper accessHelper) {
        this.dataAccess = dataAccess;
        this.accessHelper = accessHelper;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        TreeData treeData = new TreeData();
        treeData.isAdmin = this.accessHelper.isAdmin(request, "Loading tree");
        List<Team> teams = this.dataAccess.getTeams();
        List<Service> services = this.dataAccess.getAllServices();
        Collections.sort(teams);
        for (Team team : teams) {
            TreeTeamData teamData = new TreeTeamData();
            teamData.teamId = team.getTeamId();
            teamData.teamName = team.getTeamName();
            List<Service> teamServices = Service.filterTeam(team.getTeamId(), services);
            Collections.sort(teamServices);
            for (Service service : teamServices) {
                TreeServiceData serviceData = new TreeServiceData();
                serviceData.serviceId = service.getServiceId();
                serviceData.serviceName = service.getServiceName();
                serviceData.isActive = service.isActive();
                serviceData.isService = service.getServiceType().equals("Service");
                teamData.services.add(serviceData);
            }
            treeData.teams.add(teamData);
        }
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)treeData, TreeData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

