/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.tree;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.tree.dao.CatalogData;
import com.northernwall.hadrian.handlers.tree.dao.CatalogServiceData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class CatalogHandler
extends AbstractHandler {
    private final DataAccess dataAccess;
    private final Gson gson;

    public CatalogHandler(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.gson = new Gson();
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        CatalogData catalogData = new CatalogData();
        List<Team> teams = this.dataAccess.getTeams();
        List<Service> services = this.dataAccess.getActiveServices();
        Collections.sort(teams);
        for (Team team : teams) {
            List<Service> teamServices = Service.filterTeam(team.getTeamId(), services);
            Collections.sort(teamServices);
            for (Service service : teamServices) {
                if (!service.getServiceType().equals("Service")) continue;
                catalogData.services.add(CatalogServiceData.create(team, service));
            }
        }
        response.setContentType("application/json; charset=utf-8");
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.gson.toJson((Object)catalogData, CatalogData.class, jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

