/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.team;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.team.dao.GetTeamData;
import com.northernwall.hadrian.handlers.team.dao.GetTeamsData;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class TeamsGetHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public TeamsGetHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        List<Team> teams = this.getDataAccess().getTeams();
        GetTeamsData getTeamsData = new GetTeamsData();
        for (Team team : teams) {
            GetTeamData getTeamData = GetTeamData.create(team);
            getTeamData.canModify = this.accessHelper.canUserModify(request, team);
            getTeamsData.teams.add(getTeamData);
        }
        this.toJson(response, getTeamsData);
        response.setStatus(200);
        request.setHandled(true);
    }
}

