/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service.helper;

import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.handlers.routing.Http400BadRequestException;
import java.util.List;

public class FolderHelper {
    private final ConfigHelper configHelper;

    public FolderHelper(ConfigHelper configHelper) {
        this.configHelper = configHelper;
    }

    public String scrubFolder(String folder, String folderName, boolean nullAllowed) {
        if (folder == null || folder.isEmpty()) {
            if (nullAllowed) {
                return null;
            }
            throw new Http400BadRequestException(folderName + " folder can not be null or empty");
        }
        String temp = folder.trim();
        if (temp == null || temp.isEmpty()) {
            if (nullAllowed) {
                return null;
            }
            throw new Http400BadRequestException(folderName + " folder can not be null or empty");
        }
        if (temp.equals("/")) {
            throw new Http400BadRequestException(folderName + " folder can not be root");
        }
        if (!temp.startsWith("/")) {
            temp = "/" + temp;
        }
        if (temp.endsWith("/") && temp.length() > 1) {
            temp = temp.substring(0, temp.length() - 1);
        }
        return temp;
    }

    public void isSubFolder(String subFolder, String subFolderName, String mainFolder, String mainFolderName) {
        String tempMainFolder;
        String tempSubFolder = subFolder;
        if (tempSubFolder.length() > 1) {
            tempSubFolder = tempSubFolder + "/";
        }
        if ((tempMainFolder = mainFolder).length() > 1) {
            tempMainFolder = tempMainFolder + "/";
        }
        if (tempSubFolder.equals(tempMainFolder)) {
            throw new Http400BadRequestException(subFolderName + " folder can not be the same as the " + mainFolderName + " folder");
        }
        if (tempSubFolder.startsWith(tempMainFolder)) {
            throw new Http400BadRequestException(subFolderName + " folder can not be a sub folder of the " + mainFolderName + " folder");
        }
    }

    public void isWhiteListed(String folder, String folderName, String user) {
        if (this.configHelper == null) {
            throw new RuntimeException("FolderHelper not yet initialized");
        }
        List<String> folderWhiteList = this.configHelper.getConfig().folderWhiteList;
        if (folderWhiteList == null || folderWhiteList.isEmpty()) {
            return;
        }
        String tempFolder = folder;
        if (tempFolder.length() > 1) {
            tempFolder = tempFolder + "/";
        }
        for (String whiteFolder : folderWhiteList) {
            String tempWhiteFolder = whiteFolder.replace("{USER}", user);
            if (!tempFolder.equals(tempWhiteFolder) && !tempFolder.startsWith(tempWhiteFolder)) continue;
            return;
        }
        throw new Http400BadRequestException(folderName + " folder is not on the whitelist");
    }
}

