/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http400BadRequestException;
import com.northernwall.hadrian.workItem.dao.SmokeTestData;
import com.northernwall.hadrian.workItem.helper.SmokeTestHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class SmokeTestExecHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final SmokeTestHelper smokeTestHelper;

    public SmokeTestExecHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, SmokeTestHelper smokeTestHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.smokeTestHelper = smokeTestHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        Team team = this.getTeam(service.getTeamId(), null);
        this.accessHelper.checkIfUserCanModify(request, team, "execute smoke test");
        Module module = this.getModule(request, service);
        if (module.getSmokeTestUrl() == null || module.getSmokeTestUrl().isEmpty()) {
            throw new Http400BadRequestException("No smoke test url defined for module");
        }
        String endPoint = request.getParameter("endPoint");
        if (endPoint == null || endPoint.isEmpty()) {
            throw new Http400BadRequestException("No end point provided");
        }
        SmokeTestData smokeTestData = this.smokeTestHelper.ExecuteSmokeTest(module.getSmokeTestUrl(), endPoint, service.getServiceName(), "manual");
        if (smokeTestData == null) {
            throw new Http400BadRequestException("Error executing smoke test");
        }
        this.toJson(response, smokeTestData);
        response.setStatus(200);
        request.setHandled(true);
    }
}

