/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceResetAllHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public ServiceResetAllHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, WorkItemProcessor workItemProcessor) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        User user = this.accessHelper.checkIfUserIsAdmin(request, "reset all services");
        LinkedList<WorkItem> workItems = new LinkedList<WorkItem>();
        for (Service service : this.getDataAccess().getActiveServices()) {
            if (!service.isDoBuilds()) continue;
            Team team = this.getDataAccess().getTeam(service.getTeamId());
            WorkItem workItem = new WorkItem(Type.service, Operation.update, user, team, service, null, null, null, null);
            workItem.setReason("Reseting Service");
            workItems.add(workItem);
        }
        this.workItemProcessor.processWorkItems(workItems);
        response.setStatus(200);
        request.setHandled(true);
    }
}

