/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.host.dao.GetHostData;
import com.northernwall.hadrian.handlers.module.dao.GetModuleData;
import com.northernwall.hadrian.handlers.service.dao.GetModuleRefData;
import com.northernwall.hadrian.handlers.service.dao.GetServiceData;
import com.northernwall.hadrian.handlers.service.helper.InfoHelper;
import com.northernwall.hadrian.handlers.service.helper.ReadAvailabilityRunnable;
import com.northernwall.hadrian.handlers.service.helper.ReadVersionRunnable;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceRefreshHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    protected final ConfigHelper configHelper;
    private final InfoHelper infoHelper;
    private final ExecutorService executorService;

    public ServiceRefreshHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, ConfigHelper configHelper, InfoHelper infoHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.configHelper = configHelper;
        this.infoHelper = infoHelper;
        this.executorService = Executors.newFixedThreadPool(20);
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=utf-8");
        Service service = this.getService(request);
        GetServiceData getServiceData = GetServiceData.create(service);
        Team team = this.getTeam(service.getTeamId(), null);
        getServiceData.canModify = this.accessHelper.canUserModify(request, team);
        if (service.isActive()) {
            this.getModuleInfo(service, getServiceData, false);
            LinkedList<Future> futures = new LinkedList<Future>();
            this.getHostInfo(service, getServiceData, futures);
            this.waitForFutures(futures, 151, 100);
        }
        this.toJson(response, getServiceData);
        response.setStatus(200);
        request.setHandled(true);
    }

    protected void getModuleInfo(Service service, GetServiceData getServiceData, boolean includeStuff) {
        List<Module> modules = this.getDataAccess().getModules(service.getServiceId());
        Collections.sort(modules);
        LinkedList<String> activeEnvironments = new LinkedList<String>();
        for (Module module : modules) {
            module.cleanEnvironmentNames(activeEnvironments);
        }
        this.arrangeEnvironments(getServiceData, activeEnvironments, modules);
        for (Module module : modules) {
            GetModuleData getModuleData = GetModuleData.create(module, this.configHelper.getConfig());
            if (includeStuff) {
                this.getModuleRefInfo(module, getModuleData);
            }
            getServiceData.modules.add(getModuleData);
        }
    }

    private void arrangeEnvironments(GetServiceData getServiceData, List<String> activeEnvironments, List<Module> modules) {
        for (String environment : this.configHelper.getConfig().environmentNames) {
            if (!activeEnvironments.contains(environment)) continue;
            getServiceData.addEnvironment(environment);
        }
        for (String environment : activeEnvironments) {
            for (Module module : modules) {
                if (module.getEnvironmentNames() == null || module.getEnvironmentNames().isEmpty() || !module.getEnvironmentNames().containsKey(environment)) continue;
                getServiceData.addModuleEnvironment(module, environment);
            }
        }
    }

    private void getModuleRefInfo(Module module, GetModuleData getModuleData) {
        GetModuleRefData tempRef;
        for (ModuleRef ref : this.getDataAccess().getModuleRefsByClient(module.getServiceId(), module.getModuleId())) {
            tempRef = GetModuleRefData.create(ref);
            Service serverService = this.getService(ref.getServerServiceId(), null);
            tempRef.serviceName = serverService.getServiceName();
            tempRef.moduleName = this.getModule(ref.getServerModuleId(), null, serverService).getModuleName();
            getModuleData.uses.add(tempRef);
        }
        Collections.sort(getModuleData.uses);
        for (ModuleRef ref : this.getDataAccess().getModuleRefsByServer(module.getServiceId(), module.getModuleId())) {
            tempRef = GetModuleRefData.create(ref);
            Service clientService = this.getService(ref.getClientServiceId(), null);
            tempRef.serviceName = clientService.getServiceName();
            tempRef.moduleName = this.getModule(ref.getClientModuleId(), null, clientService).getModuleName();
            getModuleData.usedBy.add(tempRef);
        }
        Collections.sort(getModuleData.usedBy);
    }

    protected void getHostInfo(Service service, GetServiceData getServiceData, List<Future> futures) {
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        Collections.sort(hosts);
        for (Host host : hosts) {
            GetModuleData getModuleData = null;
            for (GetModuleData temp : getServiceData.modules) {
                if (!host.getModuleId().equals(temp.moduleId)) continue;
                getModuleData = temp;
            }
            if (getModuleData == null) continue;
            GetHostData getHostData = GetHostData.create(host);
            getServiceData.addHost(getHostData, getModuleData);
            futures.add(this.executorService.submit(new ReadVersionRunnable(getHostData, getModuleData, this.infoHelper)));
            futures.add(this.executorService.submit(new ReadAvailabilityRunnable(getHostData, getModuleData, this.infoHelper)));
        }
    }
}

