/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.module.dao.PostModuleRefData;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceRefCreateHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public ServiceRefCreateHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostModuleRefData data = this.fromJson(request, PostModuleRefData.class);
        Service clientService = this.getService(data.clientServiceId, null);
        Team team = this.getTeam(clientService.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, team, "add a service ref");
        Module clientModule = this.getModule(data.clientModuleId, null, clientService);
        Service serverService = this.getService(data.serverServiceId, null);
        Module serverModule = this.getModule(data.serverModuleId, null, serverService);
        ModuleRef ref = new ModuleRef(data.clientServiceId, data.clientModuleId, data.serverServiceId, data.serverModuleId);
        this.getDataAccess().saveModuleRef(ref);
        HashMap<String, String> notes = new HashMap<String, String>();
        notes.put("Uses", serverService.getServiceName() + " " + serverModule.getModuleName());
        this.createAudit(data.clientServiceId, clientModule.getModuleName(), user.getUsername(), notes);
        notes = new HashMap();
        notes.put("Use_By", clientService.getServiceName() + " " + clientModule.getModuleName());
        this.createAudit(data.serverServiceId, serverModule.getModuleName(), user.getUsername(), notes);
        response.setStatus(200);
        request.setHandled(true);
    }

    private void createAudit(String serviceId, String moduleName, String requestor, Map<String, String> notes) {
        Audit audit = new Audit();
        audit.serviceId = serviceId;
        audit.moduleName = moduleName;
        audit.setTimePerformed(GMT.getGmtAsDate());
        audit.timeRequested = GMT.getGmtAsDate();
        audit.requestor = requestor;
        audit.type = Type.serviceRef;
        audit.operation = Operation.create;
        audit.notes = this.getGson().toJson(notes);
        this.getDataAccess().saveAudit(audit, null);
    }
}

