/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.SearchResult;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http400BadRequestException;
import com.northernwall.hadrian.handlers.routing.Http405NotAllowedException;
import com.northernwall.hadrian.handlers.service.dao.PutServiceData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceModifyHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public ServiceModifyHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, WorkItemProcessor workItemProcessor) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PutServiceData data = this.fromJson(request, PutServiceData.class);
        if (data.serviceId == null) {
            throw new Http400BadRequestException("Illegal call, missing serviceId");
        }
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, team, "modify a service");
        for (Service temp : this.getDataAccess().getActiveServices()) {
            if (!temp.getServiceName().equalsIgnoreCase(data.serviceName) || temp.getServiceId().equals(data.serviceId)) continue;
            throw new Http405NotAllowedException("A service already exists with this name");
        }
        SearchResult searchResult = this.getDataAccess().doSearch("serviceName", data.serviceName);
        if (searchResult != null && !searchResult.serviceId.equals(data.serviceId)) {
            throw new Http405NotAllowedException("A service already exists with this name");
        }
        if (data.doBuilds) {
            if (data.gitProject == null || data.gitProject.isEmpty()) {
                throw new Http400BadRequestException("Git Project is mising or empty");
            }
            if (data.gitProject.length() > 30) {
                throw new Http400BadRequestException("Git Project is to long, max is 30");
            }
            searchResult = this.getDataAccess().doSearch("gitProject", data.gitProject);
            if (searchResult != null && !searchResult.serviceId.equals(data.serviceId)) {
                throw new Http405NotAllowedException("A service already exists at this Git Project location");
            }
        } else {
            data.gitProject = null;
        }
        List<Module> modules = this.getDataAccess().getModules(data.serviceId);
        if (data.doDeploys || data.doBuilds) {
            if (data.mavenGroupId == null || data.mavenGroupId.isEmpty()) {
                throw new Http400BadRequestException("Maven Group is mising or empty");
            }
            if (modules != null && !modules.isEmpty()) {
                for (Module module : modules) {
                    if (module.getMavenArtifactId() == null || module.getMavenArtifactId().isEmpty() || (searchResult = this.getDataAccess().doSearch("mavenGroupArtifact", data.mavenGroupId + "." + module.getMavenArtifactId())) == null || searchResult.moduleId.equals(module.getModuleId())) continue;
                    throw new Http405NotAllowedException("A service and module already exists with this Maven group '" + data.mavenGroupId + "' and artifact '" + module.getMavenArtifactId() + "'");
                }
            }
        } else {
            data.mavenGroupId = null;
        }
        if (data.testStyle.equals("Maven")) {
            data.testHostname = null;
            data.testRunAs = null;
            data.testDeploymentFolder = null;
            data.testCmdLine = null;
        }
        this.getDataAccess().deleteSearch("serviceName", service.getServiceName());
        if (service.getGitProject() != null && !service.getGitProject().isEmpty()) {
            this.getDataAccess().deleteSearch("gitProject", service.getGitProject());
        }
        if (service.getMavenGroupId() != null && !service.getMavenGroupId().isEmpty() && modules != null && !modules.isEmpty()) {
            for (Module module : modules) {
                if (module.getMavenArtifactId() == null || module.getMavenArtifactId().isEmpty()) continue;
                this.getDataAccess().deleteSearch("mavenGroupArtifact", service.getMavenGroupId() + "." + module.getMavenArtifactId());
            }
        }
        service.setServiceName(data.serviceName);
        service.setDescription(data.description);
        service.setScope(data.scope);
        service.setHaFunctionality(data.haFunctionality);
        service.setHaPerformance(data.haPerformance);
        service.setHaData(data.haData);
        service.setHaNotes(data.haNotes);
        service.setDoBuilds(data.doBuilds);
        service.setDoDeploys(data.doDeploys);
        service.setDoManageVip(data.doManageVip);
        service.setDoCheckJar(data.doCheckJar);
        service.setDoFindBugsLevel(data.doFindBugsLevel);
        service.setGitProject(data.gitProject);
        service.setMavenGroupId(data.mavenGroupId);
        service.setTestStyle(data.testStyle);
        service.setTestHostname(data.testHostname);
        service.setTestRunAs(data.testRunAs);
        service.setTestDeploymentFolder(data.testDeploymentFolder);
        service.setTestCmdLine(data.testCmdLine);
        service.setTestTimeOut(data.testTimeOut);
        this.getDataAccess().updateService(service);
        this.getDataAccess().insertSearch("serviceName", data.serviceName, service.getServiceId(), null, null);
        if (service.getGitProject() != null && !service.getGitProject().isEmpty()) {
            this.getDataAccess().insertSearch("gitProject", data.gitProject, service.getServiceId(), null, null);
        }
        if (service.getMavenGroupId() != null && !service.getMavenGroupId().isEmpty() && modules != null && !modules.isEmpty()) {
            for (Module module : modules) {
                if (module.getMavenArtifactId() == null || module.getMavenArtifactId().isEmpty()) continue;
                this.getDataAccess().insertSearch("mavenGroupArtifact", service.getMavenGroupId() + "." + module.getMavenArtifactId(), service.getServiceId(), module.getModuleId(), null);
            }
        }
        WorkItem workItem = new WorkItem(Type.service, Operation.update, user, team, service, null, null, null, null);
        for (Module temp : modules) {
            workItem.addModule(temp);
        }
        this.workItemProcessor.processWorkItem(workItem);
        response.setStatus(200);
        request.setHandled(true);
    }
}

