/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.DataStore;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.handlers.module.dao.GetModuleData;
import com.northernwall.hadrian.handlers.service.ServiceRefreshHandler;
import com.northernwall.hadrian.handlers.service.dao.GetCustomFunctionData;
import com.northernwall.hadrian.handlers.service.dao.GetDataStoreData;
import com.northernwall.hadrian.handlers.service.dao.GetServiceData;
import com.northernwall.hadrian.handlers.service.helper.InfoHelper;
import com.northernwall.hadrian.handlers.vip.dao.GetVipData;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceGetHandler
extends ServiceRefreshHandler {
    private final AccessHelper accessHelper;

    public ServiceGetHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, ConfigHelper configHelper, InfoHelper infoHelper) {
        super(dataAccess, gson, accessHelper, configHelper, infoHelper);
        this.accessHelper = accessHelper;
    }

    @Override
    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json; charset=utf-8");
        Service service = this.getService(request);
        GetServiceData getServiceData = GetServiceData.create(service);
        Team team = this.getTeam(service.getTeamId(), null);
        getServiceData.canModify = this.accessHelper.canUserModify(request, team);
        if (service.isActive()) {
            this.getModuleInfo(service, getServiceData, true);
            LinkedList<Future> futures = new LinkedList<Future>();
            this.getVipInfo(service, getServiceData);
            this.getHostInfo(service, getServiceData, futures);
            this.getDataStoreInfo(service, getServiceData);
            this.getCustomFunctionInfo(service, getServiceData);
            this.waitForFutures(futures, 151, 100);
        }
        this.toJson(response, getServiceData);
        response.setStatus(200);
        request.setHandled(true);
    }

    private void getCustomFunctionInfo(Service service, GetServiceData getServiceData) {
        List<CustomFunction> customFunctions = this.getDataAccess().getCustomFunctions(service.getServiceId());
        Collections.sort(customFunctions);
        for (CustomFunction customFunction : customFunctions) {
            if (customFunction.isTeamOnly() && !getServiceData.canModify) continue;
            GetCustomFunctionData getCustomFunctionData = GetCustomFunctionData.create(customFunction);
            getServiceData.addCustomFunction(getCustomFunctionData);
        }
    }

    private void getDataStoreInfo(Service service, GetServiceData getServiceData) {
        List<DataStore> dataStores = this.getDataAccess().getDataStores(service.getServiceId());
        Collections.sort(dataStores);
        for (DataStore dataStore : dataStores) {
            GetDataStoreData getDataStoreData = GetDataStoreData.create(dataStore);
            getServiceData.dataStores.add(getDataStoreData);
        }
    }

    private void getVipInfo(Service service, GetServiceData getServiceData) {
        List<Vip> vips = this.getDataAccess().getVips(service.getServiceId());
        Collections.sort(vips);
        for (Vip vip : vips) {
            GetModuleData getModuleData = null;
            for (GetModuleData temp : getServiceData.modules) {
                if (!vip.getModuleId().equals(temp.moduleId)) continue;
                getModuleData = temp;
            }
            if (getModuleData == null) continue;
            GetVipData getVipData = GetVipData.create(vip);
            getServiceData.addVip(getVipData, getModuleData);
        }
    }
}

