/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http400BadRequestException;
import com.northernwall.hadrian.handlers.routing.Http405NotAllowedException;
import com.northernwall.hadrian.handlers.service.dao.GetServiceData;
import com.northernwall.hadrian.handlers.service.dao.PostServiceData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceCreateHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public ServiceCreateHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, WorkItemProcessor workItemProcessor) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostServiceData data = this.fromJson(request, PostServiceData.class);
        if (data.teamId == null || data.teamId.isEmpty()) {
            throw new Http400BadRequestException("teamId attribute is mising");
        }
        Team team = this.getTeam(data.teamId, null);
        User user = this.accessHelper.checkIfUserCanModify(request, team, "create a service");
        if (data.serviceName == null || data.serviceName.isEmpty()) {
            throw new Http400BadRequestException("Service Name is mising or empty");
        }
        if (data.serviceName.length() > 30) {
            throw new Http400BadRequestException("Service Name is to long, max is 30");
        }
        if (this.getDataAccess().doSearch("serviceName", data.serviceName) != null) {
            throw new Http405NotAllowedException("A service already exists with this name");
        }
        if (data.description.length() > 500) {
            throw new Http400BadRequestException("Description is to long, max is 500");
        }
        if (data.doBuilds) {
            if (data.gitProject == null || data.gitProject.isEmpty()) {
                throw new Http400BadRequestException("Git Project is mising or empty");
            }
            if (data.gitProject.length() > 30) {
                throw new Http400BadRequestException("Git Project is to long, max is 30");
            }
            if (this.getDataAccess().doSearch("gitProject", data.gitProject) != null) {
                throw new Http405NotAllowedException("A service already exists at this Git Project location");
            }
        } else {
            data.gitProject = null;
        }
        if (data.doDeploys || data.doBuilds) {
            if (data.mavenGroupId == null || data.mavenGroupId.isEmpty()) {
                throw new Http400BadRequestException("Maven Group is mising or empty");
            }
        } else {
            data.mavenGroupId = null;
        }
        if (data.testStyle.equals("Maven")) {
            data.testHostname = null;
            data.testRunAs = null;
            data.testDeploymentFolder = null;
            data.testCmdLine = null;
        }
        Service service = new Service(data.serviceName, data.teamId, data.description, data.serviceType, data.gitProject, data.scope, data.haFunctionality, data.haPerformance, data.haData, data.haNotes, data.mavenGroupId, data.doBuilds, data.doDeploys, data.doManageVip, data.doCheckJar, data.doFindBugsLevel, data.testStyle, data.testHostname, data.testRunAs, data.testDeploymentFolder, data.testCmdLine, data.testTimeOut, true);
        this.getDataAccess().saveService(service);
        this.getDataAccess().insertSearch("serviceName", data.serviceName, service.getServiceId(), null, null);
        if (data.gitProject != null && !data.gitProject.isEmpty()) {
            this.getDataAccess().insertSearch("gitProject", data.gitProject, service.getServiceId(), null, null);
        }
        WorkItem workItem = new WorkItem(Type.service, Operation.create, user, team, service, null, null, null, null);
        this.workItemProcessor.processWorkItem(workItem);
        GetServiceData getServiceData = GetServiceData.create(service);
        this.toJson(response, getServiceData);
        response.setStatus(200);
        request.setHandled(true);
    }
}

