/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.details.ServiceBuildHelper;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http400BadRequestException;
import com.northernwall.hadrian.handlers.service.dao.BuildServiceData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ServiceBuildHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final ServiceBuildHelper serviceBuildHelper;

    public ServiceBuildHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, ServiceBuildHelper serviceBuildHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.serviceBuildHelper = serviceBuildHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        BuildServiceData data = this.fromJson(request, BuildServiceData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getDataAccess().getTeam(service.getTeamId());
        User user = this.accessHelper.checkIfUserCanModify(request, team, "trigger service build");
        if (!service.isDoBuilds()) {
            throw new Http400BadRequestException("Service not configured to do builds");
        }
        this.serviceBuildHelper.triggerBuild(team, service, data.branch, user);
        response.setStatus(200);
        request.setHandled(true);
    }
}

