/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Document;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http400BadRequestException;
import com.northernwall.hadrian.handlers.service.dao.PostDocumentData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class DocumentCreateHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public DocumentCreateHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostDocumentData data = this.fromJson(request, PostDocumentData.class);
        Service service = this.getService(data.serviceId, null);
        Team team = this.getTeam(service.getTeamId(), null);
        this.accessHelper.checkIfUserCanModify(request, team, "add a document");
        if (data.title == null) {
            throw new Http400BadRequestException("Failed to add new document, as title is null");
        }
        if (data.link == null) {
            throw new Http400BadRequestException("Failed to add new document, as link is null");
        }
        data.title = data.title.trim();
        data.link = data.link.trim();
        if (data.title.isEmpty()) {
            throw new Http400BadRequestException("Failed to add new document, as title is empty");
        }
        if (data.link.isEmpty()) {
            throw new Http400BadRequestException("Failed to add new document, as link is empty");
        }
        for (Document temp : service.getDocuments()) {
            if (!temp.getTitle().equalsIgnoreCase(data.title)) continue;
            throw new Http400BadRequestException("Failed to add new document, a document with that title already exists");
        }
        if (!data.link.toLowerCase().startsWith("http://") && !data.link.toLowerCase().startsWith("https://")) {
            data.link = "http://" + data.link;
        }
        Document document = new Document(data.documentType, data.title, data.link);
        service.getDocuments().add(document);
        response.setStatus(200);
        request.setHandled(true);
    }
}

