/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http404NotFoundException;
import com.northernwall.hadrian.handlers.service.dao.PostCustomFunctionData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class CustomFuntionModifyHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public CustomFuntionModifyHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        PostCustomFunctionData data = this.fromJson(request, PostCustomFunctionData.class);
        CustomFunction customFunction = this.getDataAccess().getCustomFunction(data.serviceId, data.cfId);
        if (customFunction == null) {
            throw new Http404NotFoundException("Could not find custom function");
        }
        Service service = this.getService(customFunction.getServiceId(), null);
        Team team = this.getTeam(service.getTeamId(), null);
        this.accessHelper.checkIfUserCanModify(request, team, "modify custom function");
        customFunction.setName(data.name);
        customFunction.setMethod(data.method);
        customFunction.setUrl(data.url);
        this.getDataAccess().updateCustomFunction(customFunction);
        response.setStatus(200);
        request.setHandled(true);
    }
}

