/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http404NotFoundException;
import com.northernwall.hadrian.handlers.service.dao.DeleteCFData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class CustomFuntionDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public CustomFuntionDeleteHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteCFData deleteCFData = this.fromJson(request, DeleteCFData.class);
        CustomFunction customFunction = this.getDataAccess().getCustomFunction(deleteCFData.serviceId, deleteCFData.cfId);
        if (customFunction == null) {
            throw new Http404NotFoundException("Could not find custom function");
        }
        Service service = this.getService(customFunction.getServiceId(), null);
        Team team = this.getTeam(service.getTeamId(), null);
        this.accessHelper.checkIfUserCanModify(request, team, "delete custom function");
        this.getDataAccess().deleteCustomFunction(deleteCFData.serviceId, deleteCFData.cfId);
        response.setStatus(200);
        request.setHandled(true);
    }
}

