/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.service;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.handlers.BasicHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditOutputGetHandler
extends BasicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditOutputGetHandler.class);

    public AuditOutputGetHandler(DataAccess dataAccess, Gson gson) {
        super(dataAccess, gson);
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String serviceId = request.getParameter("serviceId");
        String auditId = request.getParameter("auditId");
        LOGGER.info("Request for Audit Output for {} on service {}", (Object)auditId, (Object)serviceId);
        response.setContentType("text/plain; charset=utf-8");
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)response.getOutputStream());){
            String output = this.getDataAccess().getAuditOutput(serviceId, auditId);
            if (output == null) {
                output = "";
            }
            w.write(output);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

