/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.report;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.report.Report;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class HostSummaryReport
extends Report {
    protected final Config config;

    public HostSummaryReport(DataAccess dataAccess, Config config, PrintWriter writer) {
        super(dataAccess, writer);
        this.config = config;
    }

    @Override
    public void runReport() throws IOException {
        List<Team> teams = this.dataAccess.getTeams();
        List<Service> services = this.dataAccess.getActiveServices();
        Collections.sort(teams);
        this.outputServiceHeader();
        this.outputModuleHeader();
        this.outputListHeader(this.config.dataCenters);
        this.outputListHeader(this.config.environmentNames);
        this.writer.println();
        for (Team team : teams) {
            List<Service> teamServices = Service.filterTeam(team.getTeamId(), services);
            Collections.sort(teamServices);
            for (Service service : teamServices) {
                List<Module> modules = this.dataAccess.getModules(service.getServiceId());
                if (modules == null || modules.isEmpty()) {
                    this.outputServiceRow(team, service);
                    this.outputModuleRow(null);
                    this.outputListRows(this.config.dataCenters, null, null);
                    this.outputListRows(this.config.environmentNames, null, null);
                    this.writer.println();
                    continue;
                }
                List<Host> hosts = this.dataAccess.getHosts(service.getServiceId());
                for (Module module : modules) {
                    this.outputServiceRow(team, service);
                    this.outputModuleRow(module);
                    if (module.getModuleType() != ModuleType.Library) {
                        List<Host> moduleHosts = Host.filterModule(module.getModuleId(), hosts);
                        HashMap<String, Integer> dcCounts = new HashMap<String, Integer>();
                        HashMap<String, Integer> envCounts = new HashMap<String, Integer>();
                        if (moduleHosts != null && !moduleHosts.isEmpty()) {
                            for (Host host : moduleHosts) {
                                int i;
                                if (dcCounts.containsKey(host.getDataCenter())) {
                                    i = dcCounts.get(host.getDataCenter()) + 1;
                                    dcCounts.put(host.getDataCenter(), i);
                                } else {
                                    dcCounts.put(host.getDataCenter(), 1);
                                }
                                if (envCounts.containsKey(host.getEnvironment())) {
                                    i = envCounts.get(host.getEnvironment()) + 1;
                                    envCounts.put(host.getEnvironment(), i);
                                    continue;
                                }
                                envCounts.put(host.getEnvironment(), 1);
                            }
                        }
                        this.outputListRows(this.config.dataCenters, dcCounts, "0");
                        this.outputListRows(this.config.environmentNames, envCounts, "0");
                    } else {
                        this.outputListRows(this.config.dataCenters, null, null);
                        this.outputListRows(this.config.environmentNames, null, null);
                    }
                    this.writer.println();
                }
            }
        }
    }
}

