/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.report;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.report.Report;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;

public class HostFullReport
extends Report {
    public HostFullReport(DataAccess dataAccess, PrintWriter writer) {
        super(dataAccess, writer);
    }

    @Override
    public void runReport() throws IOException {
        List<Team> teams = this.dataAccess.getTeams();
        List<Service> services = this.dataAccess.getActiveServices();
        Collections.sort(teams);
        this.outputServiceHeader();
        this.outputModuleHeader();
        this.outputHostHeader();
        this.writer.println();
        for (Team team : teams) {
            List<Service> teamServices = Service.filterTeam(team.getTeamId(), services);
            Collections.sort(teamServices);
            for (Service service : teamServices) {
                List<Module> modules = this.dataAccess.getModules(service.getServiceId());
                if (modules == null || modules.isEmpty()) {
                    this.outputServiceRow(team, service);
                    this.outputModuleRow(null);
                    this.outputHostRow(null);
                    this.writer.println();
                    continue;
                }
                List<Host> hosts = this.dataAccess.getHosts(service.getServiceId());
                for (Module module : modules) {
                    List<Host> moduleHosts = Host.filterModule(module.getModuleId(), hosts);
                    if (moduleHosts == null || moduleHosts.isEmpty()) {
                        this.outputServiceRow(team, service);
                        this.outputModuleRow(module);
                        this.outputHostRow(null);
                        this.writer.println();
                        continue;
                    }
                    for (Host host : moduleHosts) {
                        this.outputServiceRow(team, service);
                        this.outputModuleRow(module);
                        this.outputHostRow(host);
                        this.writer.println();
                    }
                }
            }
        }
    }
}

