/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.module;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleFile;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.routing.Http400BadRequestException;
import com.northernwall.hadrian.handlers.service.dao.GetModuleFileData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class ModuleFileGetHandler
extends BasicHandler {
    private final AccessHelper accessHelper;

    public ModuleFileGetHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        Team team = this.getTeam(service.getTeamId(), null);
        Module module = this.getModule(request, service);
        this.accessHelper.checkIfUserCanModify(request, team, "manage file for module");
        String environment = request.getParameter("environment");
        if (environment == null || environment.isEmpty()) {
            throw new Http400BadRequestException("parameter environment is missing");
        }
        ArrayList<GetModuleFileData> getModuleFileDataList = new ArrayList<GetModuleFileData>();
        List<ModuleFile> moduleFiles = this.getDataAccess().getModuleFiles(service.getServiceId(), module.getModuleId(), environment);
        if (moduleFiles != null && !moduleFiles.isEmpty()) {
            for (ModuleFile moduleFile : moduleFiles) {
                getModuleFileDataList.add(new GetModuleFileData(moduleFile.getName(), moduleFile.getContents()));
            }
        }
        try (JsonWriter jw = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream()));){
            this.getGson().toJson(getModuleFileDataList, new TypeToken<List<GetModuleFileData>>(){}.getType(), jw);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

