/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.host;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.details.HostDetailsHelper;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.host.dao.GetHostDetailsData;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostGetDetailsHandler
extends BasicHandler {
    private final HostDetailsHelper hostDetailsHelper;

    public HostGetDetailsHandler(DataAccess dataAccess, Gson gson, HostDetailsHelper hostDetailsHelper) {
        super(dataAccess, gson);
        this.hostDetailsHelper = hostDetailsHelper;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Service service = this.getService(request);
        Host host = this.getHost(request, service);
        GetHostDetailsData details = this.hostDetailsHelper.getDetails(host);
        this.toJson(response, details);
        response.setStatus(200);
        request.setHandled(true);
    }
}

