/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.host;

import com.google.gson.Gson;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Operation;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Type;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.host.dao.DeleteHostData;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class HostDeleteHandler
extends BasicHandler {
    private final AccessHelper accessHelper;
    private final WorkItemProcessor workItemProcessor;

    public HostDeleteHandler(DataAccess dataAccess, Gson gson, AccessHelper accessHelper, WorkItemProcessor workItemProcessor) {
        super(dataAccess, gson);
        this.accessHelper = accessHelper;
        this.workItemProcessor = workItemProcessor;
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        DeleteHostData data = this.fromJson(request, DeleteHostData.class);
        Service service = this.getService(data.serviceId, data.serviceName);
        Team team = this.getTeam(service.getTeamId(), null);
        User user = this.accessHelper.checkIfUserCanModify(request, team, "delete host");
        Module module = this.getModule(data.moduleId, data.moduleName, service);
        List<Host> hosts = this.getDataAccess().getHosts(service.getServiceId());
        if (hosts == null || hosts.isEmpty()) {
            return;
        }
        for (Host host : hosts) {
            if (!host.getModuleId().equals(module.getModuleId()) || !host.getEnvironment().equals(data.environment) || !data.hostNames.contains(host.getHostName()) || host.isBusy()) continue;
            this.getDataAccess().updateSatus(host.getHostId(), true, "Deleting...");
            ArrayList<WorkItem> workItems = new ArrayList<WorkItem>(2);
            if (service.isDoManageVip()) {
                WorkItem workItemDisable = new WorkItem(Type.host, Operation.removeVips, user, team, service, module, host, null, null);
                workItems.add(workItemDisable);
            }
            WorkItem workItemDelete = new WorkItem(Type.host, Operation.delete, user, team, service, module, host, null, data.reason);
            workItems.add(workItemDelete);
            this.workItemProcessor.processWorkItems(workItems);
        }
        response.setStatus(200);
        request.setHandled(true);
    }
}

