/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.dashboard;

import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleType;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.handlers.BasicHandler;
import com.northernwall.hadrian.handlers.dashboard.dao.GetDashboardData;
import com.northernwall.hadrian.handlers.dashboard.dao.GetDataCenterData;
import com.northernwall.hadrian.handlers.dashboard.dao.GetModuleData;
import com.northernwall.hadrian.handlers.dashboard.helper.ReadAvailabilityRunnable;
import com.northernwall.hadrian.handlers.service.helper.InfoHelper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;

public class DashboardHandler
extends BasicHandler {
    private final InfoHelper infoHelper;
    private final ExecutorService executorService;

    public DashboardHandler(DataAccess dataAccess, Gson gson, InfoHelper infoHelper) {
        super(dataAccess, gson);
        this.infoHelper = infoHelper;
        this.executorService = Executors.newFixedThreadPool(20);
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        Team team = this.getTeam(request);
        String environment = request.getParameter("env");
        GetDashboardData getDashboardData = new GetDashboardData();
        getDashboardData.teamName = team.getTeamName();
        List<Service> services = Service.filterTeam(team.getTeamId(), this.getDataAccess().getActiveServices());
        LinkedList<Future> futures = new LinkedList<Future>();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                List<Module> modules = this.getDataAccess().getModules(service.getServiceId());
                List<Host> hosts = null;
                if (modules == null || modules.isEmpty()) continue;
                for (Module module : modules) {
                    List<Host> moduleHosts;
                    if (module.getModuleType() != ModuleType.Deployable) continue;
                    if (hosts == null) {
                        hosts = this.getDataAccess().getHosts(service.getServiceId());
                    }
                    if ((moduleHosts = Host.filterModule(module.getModuleId(), environment, hosts)) == null || moduleHosts.isEmpty()) continue;
                    GetModuleData moduleData = new GetModuleData();
                    moduleData.serviceId = service.getServiceId();
                    moduleData.serviceName = service.getServiceName();
                    moduleData.moduleName = module.getModuleName();
                    getDashboardData.addModule(moduleData);
                    for (Host host : moduleHosts) {
                        GetDataCenterData dataCenterData = moduleData.counts.get(host.getDataCenter());
                        if (dataCenterData == null) {
                            dataCenterData = new GetDataCenterData();
                            moduleData.counts.put(host.getDataCenter(), dataCenterData);
                        }
                        futures.add(this.executorService.submit(new ReadAvailabilityRunnable(dataCenterData, host, module, this.infoHelper)));
                    }
                }
            }
        }
        this.waitForFutures(futures, 151, 100);
        this.toJson(response, getDashboardData);
        response.setStatus(200);
        request.setHandled(true);
    }
}

