/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.caching;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import com.northernwall.hadrian.handlers.caching.CachedContent;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentHandler
extends AbstractHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentHandler.class);
    private final String rootPath;
    private final String indexPath;
    private final HtmlCompressor compressor;
    private final LoadingCache<String, CachedContent> cache;

    public ContentHandler(String rootPath) {
        this.rootPath = rootPath;
        this.indexPath = rootPath + "/index.html";
        this.compressor = new HtmlCompressor();
        this.cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, CachedContent>(){

            public CachedContent load(String key) throws IOException {
                try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(key);){
                    if (is == null) {
                        CachedContent cachedContent = null;
                        return cachedContent;
                    }
                    CachedContent cachedContent = new CachedContent(key, is, ContentHandler.this.compressor);
                    return cachedContent;
                }
            }
        });
    }

    public void preload(String resource) {
        try {
            this.cache.get((Object)(this.rootPath + resource));
        }
        catch (ExecutionException ex) {
            LOGGER.warn("Failed to preload {}, {}", (Object)resource, (Object)ex.getMessage());
        }
    }

    public void handle(String target, Request request, HttpServletRequest httpRequest, HttpServletResponse response) throws IOException, ServletException {
        String path = target.equals("/ui/") ? this.indexPath : this.rootPath + target.substring(3);
        if (this.getContent(response, path)) {
            response.setStatus(200);
            request.setHandled(true);
        }
    }

    private boolean getContent(HttpServletResponse response, String resource) {
        try {
            CachedContent content = (CachedContent)this.cache.get((Object)resource);
            if (content == null) {
                LOGGER.warn("Could not get content {}", (Object)resource);
                return false;
            }
            if (resource.toLowerCase().endsWith(".html")) {
                response.addHeader("X-Frame-Options", "DENY");
                response.setContentType("text/html; charset=utf-8");
            }
            content.write(response.getOutputStream());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

