/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.handlers.caching;

import com.googlecode.htmlcompressor.compressor.HtmlCompressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedContent.class);
    private final String resource;
    private final byte[] bytes;

    public static String compressionJS(String origText) {
        int len = origText.length();
        StringBuilder b = new StringBuilder(len);
        char c = origText.charAt(0);
        for (int i = 1; i < len; ++i) {
            char n = origText.charAt(i);
            if (c == ' ' && n == ' ') {
                c = n;
                continue;
            }
            if (c == '\n' && n == ' ' || c != ';' && n == '\n') continue;
            b.append(c);
            c = n;
        }
        b.append(c);
        return b.toString();
    }

    public CachedContent(String resource, InputStream inputStream, HtmlCompressor compressor) throws IOException {
        this.resource = resource;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[51200];
        int len = inputStream.read(buffer);
        while (len != -1) {
            outputStream.write(buffer, 0, len);
            len = inputStream.read(buffer);
        }
        if (resource.endsWith(".html")) {
            int origSize = outputStream.size();
            this.bytes = compressor.compress(outputStream.toString()).getBytes();
            LOGGER.info("Loaded content {} into cache, {} bytes, was {} bytes", new Object[]{resource, this.bytes.length, origSize});
        } else if ((resource.startsWith("/webapp/js/") || resource.startsWith("/webcontent/js/")) && resource.endsWith(".js")) {
            int origSize = outputStream.size();
            this.bytes = outputStream.toByteArray();
            LOGGER.info("Loaded content {} into cache, {} bytes, was {} bytes", new Object[]{resource, this.bytes.length, origSize});
        } else {
            this.bytes = outputStream.toByteArray();
            LOGGER.info("Loaded content {} into cache, {} bytes", (Object)resource, (Object)this.bytes.length);
        }
    }

    public void write(ServletOutputStream outputStream) {
        try {
            outputStream.write(this.bytes);
        }
        catch (Exception ex) {
            LOGGER.warn("Exception while writing content {}, {}", (Object)this.resource, (Object)ex.getMessage());
        }
        try {
            outputStream.flush();
        }
        catch (Exception ex) {
            LOGGER.warn("Exception while flushing content {}, {}", (Object)this.resource, (Object)ex.getMessage());
        }
    }
}

