/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.domain;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class Host
implements Comparable<Host> {
    private String hostId = UUID.randomUUID().toString();
    private String hostName;
    private String serviceId;
    private String moduleId;
    private boolean busy;
    private String status;
    private String dataCenter;
    private String environment;
    private String platform;

    public static List<Host> filterModule(String moduleId, List<Host> hosts) {
        if (hosts == null || hosts.isEmpty() || moduleId == null) {
            return null;
        }
        LinkedList<Host> temp = new LinkedList<Host>();
        for (Host host : hosts) {
            if (!host.getModuleId().equals(moduleId)) continue;
            temp.add(host);
        }
        return temp;
    }

    public static List<Host> filterModule(String moduleId, String environment, List<Host> hosts) {
        if (hosts == null || hosts.isEmpty() || moduleId == null) {
            return null;
        }
        LinkedList<Host> temp = new LinkedList<Host>();
        for (Host host : hosts) {
            if (!host.getModuleId().equals(moduleId) || !host.getEnvironment().equals(environment)) continue;
            temp.add(host);
        }
        return temp;
    }

    public Host() {
        this.hostName = null;
        this.serviceId = null;
        this.busy = false;
        this.status = "-";
        this.dataCenter = null;
        this.environment = null;
        this.platform = null;
    }

    public Host(String hostName, String serviceId, String moduleId, String dataCenter, String environment, String platform) {
        this.hostName = hostName;
        this.serviceId = serviceId;
        this.busy = false;
        this.status = "-";
        this.moduleId = moduleId;
        this.dataCenter = dataCenter;
        this.environment = environment;
        this.platform = platform;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(boolean busy, String status) {
        this.busy = busy;
        this.status = status;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @Override
    public int compareTo(Host o) {
        return this.hostName.compareTo(o.hostName);
    }
}

