/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db.inMemory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonWriter;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.DataAccessFactory;
import com.northernwall.hadrian.db.inMemory.InMemoryDataAccess;
import com.northernwall.hadrian.parameters.Parameters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.dshops.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDataAccessFactory
implements DataAccessFactory,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InMemoryDataAccessFactory.class);
    private InMemoryDataAccess dataAccess;
    private String dataFileName;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public DataAccess createDataAccess(Parameters parameters, Gson gson, MetricRegistry metricRegistry) {
        this.dataFileName = parameters.getString("dataAccess.inMemory.dataFileName", "data.json");
        this.dataAccess = this.load();
        if (this.dataAccess == null) {
            LOGGER.info("Creating a new In Memory store");
            this.dataAccess = new InMemoryDataAccess();
        }
        Thread thread = new Thread(this);
        Runtime.getRuntime().addShutdownHook(thread);
        return this.dataAccess;
    }

    private InMemoryDataAccess load() {
        File file = new File(this.dataFileName);
        if (!file.exists()) {
            return null;
        }
        try {
            return (InMemoryDataAccess)this.gson.fromJson((Reader)new FileReader(file), InMemoryDataAccess.class);
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("Failed to read file, {}", (Object)ex.getMessage());
            return null;
        }
    }

    @Override
    public void run() {
        File file = new File(this.dataFileName);
        try (JsonWriter jw = new JsonWriter((Writer)new FileWriter(file));){
            this.gson.toJson((Object)this.dataAccess, InMemoryDataAccess.class, jw);
            LOGGER.info("In Memory store saved to disk, {}", (Object)file.getName());
        }
        catch (Exception ex) {
            LOGGER.error("Faled to save In Memory, {}", (Object)ex.getMessage());
        }
    }
}

