/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.gson.Gson;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.DataAccessFactory;
import com.northernwall.hadrian.db.cassandra.CassandraDataAccess;
import com.northernwall.hadrian.parameters.Parameters;
import org.dshops.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDataAccessFactory
implements DataAccessFactory,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDataAccessFactory.class);
    private Cluster cluster;
    private CassandraDataAccess dataAccess;

    @Override
    public DataAccess createDataAccess(Parameters parameters, Gson gson, MetricRegistry metricRegistry) {
        String nodes = parameters.getString("dataAccess.cassandra.nodes", "127.0.0.1");
        String dataCenter = parameters.getString("dataAccess.cassandra.dataCenter", null);
        String username = parameters.getString("dataAccess.cassandra.username", null);
        String password = parameters.getString("dataAccess.cassandra.password", null);
        boolean createKeyspace = parameters.getBoolean("dataAccess.cassandra.createKeyspace", true);
        String keyspace = parameters.getString("dataAccess.cassandra.keyspace", "hadrian");
        int replicationFactor = parameters.getInt("dataAccess.cassandra.replicationFactor", 1);
        int auditTimeToLive = parameters.getInt("dataAccess.cassandra.auditTtlDays", 732) * 86400;
        int statusTimeToLive = parameters.getInt("dataAccess.cassandra.auditTtlDays", 2) * 86400;
        this.connect(nodes, dataCenter, username, password);
        this.setup(createKeyspace, keyspace, replicationFactor);
        this.dataAccess = new CassandraDataAccess(this.cluster, keyspace, username, dataCenter, auditTimeToLive, statusTimeToLive, gson, metricRegistry);
        Thread thread = new Thread(this);
        Runtime.getRuntime().addShutdownHook(thread);
        return this.dataAccess;
    }

    private void connect(String nodes, String dataCenter, String username, String password) {
        String[] nodeParts;
        Cluster.Builder builder = Cluster.builder();
        if (nodes == null || nodes.isEmpty()) {
            throw new RuntimeException("dataAccess.cassandra.nodes is not defined");
        }
        if (dataCenter != null && !dataCenter.isEmpty()) {
            DCAwareRoundRobinPolicy policy = DCAwareRoundRobinPolicy.builder().withLocalDc(dataCenter).build();
            builder.withLoadBalancingPolicy((LoadBalancingPolicy)policy);
        }
        for (String node : nodeParts = nodes.split(",")) {
            if ((node = node.trim()).isEmpty()) continue;
            LOGGER.info("Adding Cassandra node {}", (Object)node);
            builder.addContactPoint(node);
        }
        if (username != null && !username.isEmpty() && password != null && !password.isEmpty()) {
            builder.withCredentials(username, password);
        }
        this.cluster = builder.build();
        Metadata metadata = this.cluster.getMetadata();
        LOGGER.info("Connected to cluster: {}", (Object)metadata.getClusterName());
        for (Host host : metadata.getAllHosts()) {
            LOGGER.info("Datacenter: {} Host: {} Rack: {}", new Object[]{host.getDatacenter(), host.getAddress(), host.getRack()});
        }
    }

    private void setup(boolean createKeyspace, String keyspace, int replicationFactor) {
        try (Session session = this.cluster.connect(keyspace);){
            if (createKeyspace) {
                session.execute("CREATE KEYSPACE IF NOT EXISTS " + keyspace + " WITH replication = {'class':'SimpleStrategy', 'replication_factor':" + replicationFactor + "};");
                LOGGER.info("Keyspace {} created", (Object)keyspace);
            } else {
                LOGGER.info("Not calling create keyspace for {}", (Object)keyspace);
            }
            session.execute("CREATE TABLE IF NOT EXISTS version (component text, version text, PRIMARY KEY (component));");
            session.execute("CREATE TABLE IF NOT EXISTS service (id text, data text, PRIMARY KEY (id));");
            session.execute("CREATE TABLE IF NOT EXISTS team (id text, data text, PRIMARY KEY (id));");
            session.execute("CREATE TABLE IF NOT EXISTS user (id text, data text, PRIMARY KEY (id));");
            session.execute("CREATE TABLE IF NOT EXISTS workItem (id text, data text, PRIMARY KEY (id));");
            session.execute("CREATE TABLE IF NOT EXISTS workItemStatus (id text, status int, PRIMARY KEY (id));");
            session.execute("CREATE TABLE IF NOT EXISTS customFunction (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
            session.execute("CREATE TABLE IF NOT EXISTS dataStore (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
            session.execute("CREATE TABLE IF NOT EXISTS host (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
            session.execute("CREATE TABLE IF NOT EXISTS module (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
            session.execute("CREATE TABLE IF NOT EXISTS moduleFile (serviceId text, moduleId text, network text, name text, data text, PRIMARY KEY (serviceId, moduleId, network, name));");
            session.execute("CREATE TABLE IF NOT EXISTS vip (serviceId text, id text, data text, PRIMARY KEY (serviceId, id));");
            session.execute("CREATE TABLE IF NOT EXISTS moduleRefClient (clientServiceId text, clientModuleId text, serverServiceId text, serverModuleId text, PRIMARY KEY (clientServiceId, clientModuleId, serverServiceId, serverModuleId));");
            session.execute("CREATE TABLE IF NOT EXISTS moduleRefServer (serverServiceId text, serverModuleId text, clientServiceId text, clientModuleId text, PRIMARY KEY (serverServiceId, serverModuleId, clientServiceId, clientModuleId));");
            session.execute("CREATE TABLE IF NOT EXISTS searchName (searchSpace text, searchText text, serviceId text, moduleId text, hostId text, PRIMARY KEY ((searchSpace), searchText));");
            session.execute("CREATE TABLE IF NOT EXISTS entityStatus (id text, time timeuuid, busy boolean, status text, PRIMARY KEY ((id), time));");
            session.execute("CREATE TABLE IF NOT EXISTS auditRecord (serviceId text, year int, month int, day int, time timeuuid, data text, PRIMARY KEY ((serviceId, year, month, day), time));");
            session.execute("CREATE TABLE IF NOT EXISTS auditOutput (serviceId text, auditId text, data text, PRIMARY KEY (serviceId, auditId));");
            LOGGER.info("Tables created");
        }
    }

    @Override
    public void run() {
        LOGGER.info("Shutting down Cassandra");
        if (this.dataAccess != null) {
            this.dataAccess.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
        LOGGER.info("Connection to cluster closed");
    }
}

