/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.gson.Gson;
import com.northernwall.hadrian.StringUtils;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.db.SearchResult;
import com.northernwall.hadrian.domain.Audit;
import com.northernwall.hadrian.domain.CustomFunction;
import com.northernwall.hadrian.domain.DataStore;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.ModuleFile;
import com.northernwall.hadrian.domain.ModuleRef;
import com.northernwall.hadrian.domain.Service;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.Vip;
import com.northernwall.hadrian.domain.WorkItem;
import com.northernwall.hadrian.handlers.utility.HealthWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.dshops.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDataAccess
implements DataAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDataAccess.class);
    private static final String CQL_SELECT_PRE = "SELECT * FROM ";
    private static final String CQL_SELECT_POST = ";";
    private final String username;
    private final String dataCenter;
    private final Session session;
    private final PreparedStatement auditSelect;
    private final PreparedStatement auditInsert;
    private final PreparedStatement auditOutputSelect;
    private final PreparedStatement auditOutputInsert;
    private final PreparedStatement versionSelect;
    private final PreparedStatement versionInsert;
    private final PreparedStatement versionUpdate;
    private final PreparedStatement customFunctionSelect;
    private final PreparedStatement customFunctionSelect2;
    private final PreparedStatement customFunctionInsert;
    private final PreparedStatement customFunctionUpdate;
    private final PreparedStatement customFunctionDelete;
    private final PreparedStatement dataStoreSelect;
    private final PreparedStatement dataStoreSelect2;
    private final PreparedStatement dataStoreInsert;
    private final PreparedStatement dataStoreUpdate;
    private final PreparedStatement dataStoreDelete;
    private final PreparedStatement hostSelect;
    private final PreparedStatement hostSelect2;
    private final PreparedStatement hostInsert;
    private final PreparedStatement hostUpdate;
    private final PreparedStatement hostDelete;
    private final PreparedStatement searchSelect;
    private final PreparedStatement searchInsert;
    private final PreparedStatement searchDelete;
    private final PreparedStatement moduleSelect;
    private final PreparedStatement moduleSelect2;
    private final PreparedStatement moduleInsert;
    private final PreparedStatement moduleUpdate;
    private final PreparedStatement moduleDelete;
    private final PreparedStatement moduleFileSelect;
    private final PreparedStatement moduleFileSelect2;
    private final PreparedStatement moduleFileInsert;
    private final PreparedStatement moduleFileUpdate;
    private final PreparedStatement moduleFileDelete;
    private final PreparedStatement serviceSelect;
    private final PreparedStatement serviceInsert;
    private final PreparedStatement serviceUpdate;
    private final PreparedStatement moduleRefSelectClient;
    private final PreparedStatement moduleRefSelectServer;
    private final PreparedStatement moduleRefInsertClient;
    private final PreparedStatement moduleRefInsertServer;
    private final PreparedStatement moduleRefDeleteClient;
    private final PreparedStatement moduleRefDeleteServer;
    private final PreparedStatement teamSelect;
    private final PreparedStatement teamInsert;
    private final PreparedStatement teamUpdate;
    private final PreparedStatement vipSelect;
    private final PreparedStatement vipSelect2;
    private final PreparedStatement vipInsert;
    private final PreparedStatement vipUpdate;
    private final PreparedStatement vipDelete;
    private final PreparedStatement workItemSelect;
    private final PreparedStatement workItemInsert;
    private final PreparedStatement workItemDelete;
    private final PreparedStatement workItemStatusSelect;
    private final PreparedStatement workItemStatusInsert;
    private final PreparedStatement statusSelect;
    private final PreparedStatement statusInsert;
    private final Gson gson;

    public CassandraDataAccess(Cluster cluster, String keyspace, String username, String dataCenter, int auditTimeToLive, int statusTimeToLive, Gson gson, MetricRegistry metricRegistry) {
        this.username = username;
        this.dataCenter = dataCenter;
        this.session = cluster.connect(keyspace);
        LOGGER.info("Praparing version statements...");
        this.versionSelect = this.session.prepare("SELECT * FROM version WHERE component = ?;");
        this.versionSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.versionInsert = this.session.prepare("INSERT INTO version (component, version) VALUES (?, ?);");
        this.versionInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.versionUpdate = this.session.prepare("UPDATE version SET version = ? WHERE component = ? ;");
        this.versionUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing customFunction statements...");
        this.customFunctionSelect = this.session.prepare("SELECT * FROM customFunction WHERE serviceId = ?;");
        this.customFunctionSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.customFunctionSelect2 = this.session.prepare("SELECT * FROM customFunction WHERE serviceId = ? AND id = ?;");
        this.customFunctionSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.customFunctionInsert = this.session.prepare("INSERT INTO customFunction (serviceId, id, data) VALUES (?, ?, ?);");
        this.customFunctionInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.customFunctionUpdate = this.session.prepare("UPDATE customFunction SET data = ? WHERE serviceId = ? AND id = ?;");
        this.customFunctionUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.customFunctionDelete = this.session.prepare("DELETE FROM customFunction WHERE serviceId = ? AND id = ?;");
        this.customFunctionDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing dataStore statements...");
        this.dataStoreSelect = this.session.prepare("SELECT * FROM dataStore WHERE serviceId = ?;");
        this.dataStoreSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreSelect2 = this.session.prepare("SELECT * FROM dataStore WHERE serviceId = ? AND id = ?;");
        this.dataStoreSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreInsert = this.session.prepare("INSERT INTO dataStore (serviceId, id, data) VALUES (?, ?, ?);");
        this.dataStoreInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreUpdate = this.session.prepare("UPDATE dataStore SET data = ? WHERE serviceId = ? AND id = ?;");
        this.dataStoreUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.dataStoreDelete = this.session.prepare("DELETE FROM dataStore WHERE serviceId = ? AND id = ?;");
        this.dataStoreDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing host statements...");
        this.hostSelect = this.session.prepare("SELECT * FROM host WHERE serviceId = ?;");
        this.hostSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostSelect2 = this.session.prepare("SELECT * FROM host WHERE serviceId = ? AND id = ?;");
        this.hostSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostInsert = this.session.prepare("INSERT INTO host (serviceId, id, data) VALUES (?, ?, ?);");
        this.hostInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostUpdate = this.session.prepare("UPDATE host SET data = ? WHERE serviceId = ? AND id = ?;");
        this.hostUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.hostDelete = this.session.prepare("DELETE FROM host WHERE serviceId = ? AND id = ?;");
        this.hostDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing module statements...");
        this.moduleSelect = this.session.prepare("SELECT * FROM module WHERE serviceId = ?;");
        this.moduleSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleSelect2 = this.session.prepare("SELECT * FROM module WHERE serviceId = ? AND id = ?;");
        this.moduleSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleInsert = this.session.prepare("INSERT INTO module (serviceId, id, data) VALUES (?, ?, ?);");
        this.moduleInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleUpdate = this.session.prepare("UPDATE module SET data = ? WHERE serviceId = ? AND id = ?;");
        this.moduleUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleDelete = this.session.prepare("DELETE FROM module WHERE serviceId = ? AND id = ?;");
        this.moduleDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing moduleFile statements...");
        this.moduleFileSelect = this.session.prepare("SELECT * FROM moduleFile WHERE serviceId = ? AND moduleId = ? AND network = ?;");
        this.moduleFileSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleFileSelect2 = this.session.prepare("SELECT * FROM moduleFile WHERE serviceId = ? AND moduleId = ? AND network = ? AND name = ?;");
        this.moduleFileSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleFileInsert = this.session.prepare("INSERT INTO moduleFile (serviceId, moduleId, network, name, data) VALUES (?, ?, ?, ?, ?);");
        this.moduleFileInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleFileUpdate = this.session.prepare("UPDATE moduleFile SET data = ? WHERE serviceId = ? AND moduleId = ? AND network = ? AND name = ?;");
        this.moduleFileUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleFileDelete = this.session.prepare("DELETE FROM moduleFile WHERE serviceId = ? AND moduleId = ? AND network = ? AND name = ?;");
        this.moduleFileDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing service statements...");
        this.serviceSelect = this.session.prepare("SELECT * FROM service WHERE id = ?;");
        this.serviceSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceInsert = this.session.prepare("INSERT INTO service (id, data) VALUES (?, ?);");
        this.serviceInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.serviceUpdate = this.session.prepare("UPDATE service SET data = ? WHERE id = ?;");
        this.serviceUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing moduleRef statements...");
        this.moduleRefSelectClient = this.session.prepare("SELECT * FROM moduleRefClient WHERE clientServiceId = ? AND clientModuleId = ?;");
        this.moduleRefSelectClient.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleRefSelectServer = this.session.prepare("SELECT * FROM moduleRefServer WHERE serverServiceId = ? AND serverModuleId = ?;");
        this.moduleRefSelectServer.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleRefInsertClient = this.session.prepare("INSERT INTO moduleRefClient (clientServiceId, clientModuleId, serverServiceId, serverModuleId) VALUES (?, ?, ?, ?);");
        this.moduleRefInsertClient.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleRefInsertServer = this.session.prepare("INSERT INTO moduleRefServer (serverServiceId, serverModuleId, clientServiceId, clientModuleId) VALUES (?, ?, ?, ?);");
        this.moduleRefInsertServer.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleRefDeleteClient = this.session.prepare("DELETE FROM moduleRefClient WHERE clientServiceId = ? AND clientModuleId = ? AND serverServiceId = ? AND serverModuleId = ?;");
        this.moduleRefDeleteClient.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.moduleRefDeleteServer = this.session.prepare("DELETE FROM moduleRefServer WHERE serverServiceId = ? AND serverModuleId = ? AND clientServiceId = ? AND clientModuleId = ?;");
        this.moduleRefDeleteServer.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing team statements...");
        this.teamSelect = this.session.prepare("SELECT * FROM team WHERE id = ?;");
        this.teamSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.teamInsert = this.session.prepare("INSERT INTO team (id, data) VALUES (?, ?);");
        this.teamInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.teamUpdate = this.session.prepare("UPDATE team SET data = ? WHERE id = ?;");
        this.teamUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing vip statements...");
        this.vipSelect = this.session.prepare("SELECT * FROM vip WHERE serviceId = ?;");
        this.vipSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipSelect2 = this.session.prepare("SELECT * FROM vip WHERE serviceId = ? AND id = ?;");
        this.vipSelect2.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipInsert = this.session.prepare("INSERT INTO vip (serviceId, id, data) VALUES (?, ?, ?);");
        this.vipInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipUpdate = this.session.prepare("UPDATE vip SET data = ? WHERE serviceId = ? AND id = ?;");
        this.vipUpdate.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.vipDelete = this.session.prepare("DELETE FROM vip WHERE serviceId = ? AND id = ?;");
        this.vipDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing workItem statements...");
        this.workItemSelect = this.session.prepare("SELECT * FROM workItem WHERE id = ?;");
        this.workItemSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.workItemInsert = this.session.prepare("INSERT INTO workItem (id, data) VALUES (?, ?);");
        this.workItemInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.workItemDelete = this.session.prepare("DELETE FROM workItem WHERE id = ?;");
        this.workItemDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing workItemStatus statements...");
        this.workItemStatusSelect = this.session.prepare("SELECT * FROM workItemStatus WHERE id = ?;");
        this.workItemStatusSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.workItemStatusInsert = this.session.prepare("INSERT INTO workItemStatus (id, status) VALUES (?, ?) USING TTL 86400;");
        this.workItemStatusInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing audit statements...");
        LOGGER.info("Audit TTL {}", (Object)auditTimeToLive);
        this.auditSelect = this.session.prepare("SELECT data FROM auditRecord WHERE serviceId = ? AND year = ? AND month = ? AND day = ?");
        this.auditInsert = this.session.prepare("INSERT INTO auditRecord (serviceId, year, month, day, time, data) VALUES (?, ?, ?, ?, now(), ?) USING TTL " + auditTimeToLive + CQL_SELECT_POST);
        this.auditInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.auditOutputSelect = this.session.prepare("SELECT data FROM auditOutput WHERE serviceId = ? AND auditId = ?");
        this.auditOutputInsert = this.session.prepare("INSERT INTO auditOutput (serviceId, auditId, data) VALUES (?, ?, ?) USING TTL " + auditTimeToLive + CQL_SELECT_POST);
        this.auditOutputInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing search statements...");
        this.searchSelect = this.session.prepare("SELECT * FROM searchName WHERE searchSpace = ? AND searchText = ?;");
        this.searchSelect.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.searchInsert = this.session.prepare("INSERT INTO searchName (searchSpace, searchText, serviceId, moduleId, hostId) VALUES (?, ?, ?, ?, ?);");
        this.searchInsert.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        this.searchDelete = this.session.prepare("DELETE FROM searchName WHERE searchSpace = ? AND searchText = ?;");
        this.searchDelete.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        LOGGER.info("Praparing status statements...");
        LOGGER.info("Status TTL {}", (Object)statusTimeToLive);
        this.statusSelect = this.session.prepare("SELECT * FROM entityStatus WHERE id = ? ORDER BY time DESC LIMIT 1;");
        this.statusInsert = this.session.prepare("INSERT INTO entityStatus (id, time, busy, status) VALUES (?, now(), ?, ?) USING TTL " + statusTimeToLive + CQL_SELECT_POST);
        LOGGER.info("Prapared statements created");
        this.gson = gson;
    }

    @Override
    public boolean getAvailability() {
        return true;
    }

    @Override
    public void getHealth(HealthWriter writer) throws IOException {
        Metadata metadata = this.session.getCluster().getMetadata();
        Session.State state = this.session.getState();
        writer.addStringLine("Cassandra - Username", this.username);
        writer.addStringLine("Cassandra - Cluster", metadata.getClusterName());
        if (this.dataCenter != null) {
            writer.addStringLine("Cassandra - Preferred DC", this.dataCenter);
        }
        writer.addStringLine("Cassandra - Keyspace", this.session.getLoggedKeyspace());
        LinkedList<String> dcs = new LinkedList<String>();
        for (com.datastax.driver.core.Host host : metadata.getAllHosts()) {
            if (dcs.contains(host.getDatacenter())) continue;
            dcs.add(host.getDatacenter());
        }
        for (String dc : dcs) {
            for (com.datastax.driver.core.Host host : metadata.getAllHosts()) {
                if (!dc.equals(host.getDatacenter())) continue;
                writer.addStringLine("Cassandra - " + host.getDatacenter(), host.getAddress().getHostAddress() + "  " + host.getRack() + "  " + host.getState() + "  v" + host.getCassandraVersion().toString() + "  open=" + state.getOpenConnections(host) + "  trashed=" + state.getTrashedConnections(host));
            }
        }
    }

    @Override
    public String getVersion() {
        BoundStatement boundStatement = new BoundStatement(this.versionSelect);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{"datastore"}));
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            return row.getString("version");
        }
        return null;
    }

    @Override
    public void setVersion(String version) {
        if (this.getVersion() == null) {
            BoundStatement boundStatement = new BoundStatement(this.versionInsert);
            this.session.execute((Statement)boundStatement.bind(new Object[]{"datastore", version}));
        } else {
            BoundStatement boundStatement = new BoundStatement(this.versionUpdate);
            this.session.execute((Statement)boundStatement.bind(new Object[]{version, "datastore"}));
        }
    }

    @Override
    public List<Team> getTeams() {
        return this.getData("team", Team.class);
    }

    @Override
    public Team getTeam(String teamId) {
        return this.getData(teamId, this.teamSelect, Team.class);
    }

    @Override
    public void saveTeam(Team team) {
        this.saveData(team.getTeamId(), this.gson.toJson((Object)team), this.teamInsert);
    }

    @Override
    public void updateTeam(Team team) {
        this.updateData(team.getTeamId(), this.gson.toJson((Object)team), this.teamUpdate);
    }

    @Override
    public List<Service> getAllServices() {
        List<Service> services = this.getData("service", Service.class);
        Collections.sort(services);
        return services;
    }

    @Override
    public List<Service> getActiveServices() {
        List<Service> services = this.getData("service", Service.class);
        LinkedList<Service> temp = new LinkedList<Service>();
        for (Service service : services) {
            if (!service.isActive()) continue;
            temp.add(service);
        }
        Collections.sort(temp);
        return temp;
    }

    @Override
    public Service getService(String serviceId) {
        return this.getData(serviceId, this.serviceSelect, Service.class);
    }

    @Override
    public void saveService(Service service) {
        this.saveData(service.getServiceId(), this.gson.toJson((Object)service), this.serviceInsert);
    }

    @Override
    public void updateService(Service service) {
        this.updateData(service.getServiceId(), this.gson.toJson((Object)service), this.serviceUpdate);
    }

    @Override
    public List<Host> getHosts(String serviceId) {
        List<Host> hosts = this.getServiceData(serviceId, this.hostSelect, Host.class);
        if (hosts == null || hosts.isEmpty()) {
            return hosts;
        }
        for (Host host : hosts) {
            Row row = this.getStatus(host.getHostId());
            if (row != null) {
                host.setStatus(row.getBool("busy"), row.getString("status"));
                continue;
            }
            host.setStatus(false, "-");
        }
        Collections.sort(hosts);
        return hosts;
    }

    @Override
    public Host getHost(String serviceId, String hostId) {
        Host host = this.getServiceData(serviceId, hostId, this.hostSelect2, Host.class);
        if (host == null) {
            return null;
        }
        Row row = this.getStatus(host.getHostId());
        if (row != null) {
            host.setStatus(row.getBool("busy"), row.getString("status"));
        } else {
            host.setStatus(false, "-");
        }
        return host;
    }

    @Override
    public void saveHost(Host host) {
        this.saveServiceData(host.getServiceId(), host.getHostId(), this.gson.toJson((Object)host), this.hostInsert);
    }

    @Override
    public void updateHost(Host host) {
        this.updateServiceData(host.getServiceId(), host.getHostId(), this.gson.toJson((Object)host), this.hostUpdate);
    }

    @Override
    public void deleteHost(Host host) {
        this.deleteServiceData(host.getServiceId(), host.getHostId(), this.hostDelete);
    }

    @Override
    public List<Module> getModules(String serviceId) {
        return this.getServiceData(serviceId, this.moduleSelect, Module.class);
    }

    @Override
    public Module getModule(String serviceId, String moduleId) {
        return this.getServiceData(serviceId, moduleId, this.moduleSelect2, Module.class);
    }

    @Override
    public void saveModule(Module module) {
        this.saveServiceData(module.getServiceId(), module.getModuleId(), this.gson.toJson((Object)module), this.moduleInsert);
    }

    @Override
    public void updateModule(Module module) {
        this.updateServiceData(module.getServiceId(), module.getModuleId(), this.gson.toJson((Object)module), this.moduleUpdate);
    }

    @Override
    public void deleteModule(String serviceId, String moduleId) {
        this.deleteServiceData(serviceId, moduleId, this.moduleDelete);
    }

    @Override
    public List<ModuleFile> getModuleFiles(String serviceId, String moduleId, String environment) {
        BoundStatement boundStatement = new BoundStatement(this.moduleFileSelect);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, moduleId, environment}));
        if (results == null || results.isExhausted()) {
            return null;
        }
        LinkedList<ModuleFile> moduleFiles = new LinkedList<ModuleFile>();
        for (Row row : results) {
            moduleFiles.add(new ModuleFile(serviceId, moduleId, environment, row.getString("name"), row.getString("data")));
        }
        return moduleFiles;
    }

    @Override
    public ModuleFile getModuleFile(String serviceId, String moduleId, String environment, String name) {
        BoundStatement boundStatement = new BoundStatement(this.moduleFileSelect2);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, moduleId, environment, name}));
        Row row = results.one();
        if (row == null) {
            return null;
        }
        return new ModuleFile(serviceId, moduleId, environment, name, row.getString("data"));
    }

    @Override
    public void saveModuleFile(ModuleFile moduleFile) {
        BoundStatement boundStatement = new BoundStatement(this.moduleFileInsert);
        this.session.execute((Statement)boundStatement.bind(new Object[]{moduleFile.getServiceId(), moduleFile.getModuleId(), moduleFile.getEnvironment(), moduleFile.getName(), moduleFile.getContents()}));
    }

    @Override
    public void updateModuleFile(ModuleFile moduleFile) {
        BoundStatement boundStatement = new BoundStatement(this.moduleFileUpdate);
        this.session.execute((Statement)boundStatement.bind(new Object[]{moduleFile.getContents(), moduleFile.getServiceId(), moduleFile.getModuleId(), moduleFile.getEnvironment(), moduleFile.getName()}));
    }

    @Override
    public void deleteModuleFile(String serviceId, String moduleId, String environment, String name) {
        BoundStatement boundStatement = new BoundStatement(this.moduleFileDelete);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, moduleId, environment, name}));
    }

    @Override
    public List<Vip> getVips(String serviceId) {
        return this.getServiceData(serviceId, this.vipSelect, Vip.class);
    }

    @Override
    public Vip getVip(String serviceId, String vipId) {
        return this.getServiceData(serviceId, vipId, this.vipSelect2, Vip.class);
    }

    @Override
    public void saveVip(Vip vip) {
        this.saveServiceData(vip.getServiceId(), vip.getVipId(), this.gson.toJson((Object)vip), this.vipInsert);
    }

    @Override
    public void updateVip(Vip vip) {
        this.updateServiceData(vip.getServiceId(), vip.getVipId(), this.gson.toJson((Object)vip), this.vipUpdate);
    }

    @Override
    public void deleteVip(String serviceId, String vipId) {
        this.deleteServiceData(serviceId, vipId, this.vipDelete);
    }

    @Override
    public List<ModuleRef> getModuleRefs() {
        ResultSet results = this.session.execute("SELECT * FROM moduleRefClient;");
        LinkedList<ModuleRef> serviceRefs = new LinkedList<ModuleRef>();
        for (Row row : results) {
            serviceRefs.add(new ModuleRef(row.getString("clientServiceId"), row.getString("clientModuleId"), row.getString("serverServiceId"), row.getString("serverModuleId")));
        }
        return serviceRefs;
    }

    @Override
    public List<ModuleRef> getModuleRefsByClient(String clientServiceId, String clientModuleId) {
        BoundStatement boundStatement = new BoundStatement(this.moduleRefSelectClient);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{clientServiceId, clientModuleId}));
        LinkedList<ModuleRef> serviceRefs = new LinkedList<ModuleRef>();
        for (Row row : results) {
            serviceRefs.add(new ModuleRef(row.getString("clientServiceId"), row.getString("clientModuleId"), row.getString("serverServiceId"), row.getString("serverModuleId")));
        }
        return serviceRefs;
    }

    @Override
    public List<ModuleRef> getModuleRefsByServer(String serverServiceId, String serverModuleId) {
        BoundStatement boundStatement = new BoundStatement(this.moduleRefSelectServer);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serverServiceId, serverModuleId}));
        LinkedList<ModuleRef> serviceRefs = new LinkedList<ModuleRef>();
        for (Row row : results) {
            serviceRefs.add(new ModuleRef(row.getString("clientServiceId"), row.getString("clientModuleId"), row.getString("serverServiceId"), row.getString("serverModuleId")));
        }
        return serviceRefs;
    }

    @Override
    public void saveModuleRef(ModuleRef moduleRef) {
        BoundStatement boundStatement = new BoundStatement(this.moduleRefInsertClient);
        this.session.execute((Statement)boundStatement.bind(new Object[]{moduleRef.getClientServiceId(), moduleRef.getClientModuleId(), moduleRef.getServerServiceId(), moduleRef.getServerModuleId()}));
        boundStatement = new BoundStatement(this.moduleRefInsertServer);
        this.session.execute((Statement)boundStatement.bind(new Object[]{moduleRef.getServerServiceId(), moduleRef.getServerModuleId(), moduleRef.getClientServiceId(), moduleRef.getClientModuleId()}));
    }

    @Override
    public void deleteModuleRef(String clientServiceId, String clientModuleId, String serverServiceId, String serverModuleId) {
        BoundStatement boundStatement = new BoundStatement(this.moduleRefDeleteClient);
        this.session.execute((Statement)boundStatement.bind(new Object[]{clientServiceId, clientModuleId, serverServiceId, serverModuleId}));
        boundStatement = new BoundStatement(this.moduleRefDeleteServer);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serverServiceId, serverModuleId, clientServiceId, clientModuleId}));
    }

    @Override
    public List<CustomFunction> getCustomFunctions(String serviceId) {
        return this.getServiceData(serviceId, this.customFunctionSelect, CustomFunction.class);
    }

    @Override
    public CustomFunction getCustomFunction(String serviceId, String customFunctionId) {
        return this.getServiceData(serviceId, customFunctionId, this.customFunctionSelect2, CustomFunction.class);
    }

    @Override
    public void saveCustomFunction(CustomFunction customFunction) {
        this.saveServiceData(customFunction.getServiceId(), customFunction.getCustomFunctionId(), this.gson.toJson((Object)customFunction), this.customFunctionInsert);
    }

    @Override
    public void updateCustomFunction(CustomFunction customFunction) {
        this.updateServiceData(customFunction.getServiceId(), customFunction.getCustomFunctionId(), this.gson.toJson((Object)customFunction), this.customFunctionUpdate);
    }

    @Override
    public void deleteCustomFunction(String serviceId, String customFunctionId) {
        this.deleteServiceData(serviceId, customFunctionId, this.customFunctionDelete);
    }

    @Override
    public List<DataStore> getDataStores(String serviceId) {
        return this.getServiceData(serviceId, this.dataStoreSelect, DataStore.class);
    }

    @Override
    public DataStore getDataStore(String serviceId, String dataStoreId) {
        return this.getServiceData(serviceId, dataStoreId, this.dataStoreSelect2, DataStore.class);
    }

    @Override
    public void saveDataStore(DataStore dataStore) {
        this.saveServiceData(dataStore.getServiceId(), dataStore.getDataStoreId(), this.gson.toJson((Object)dataStore), this.dataStoreInsert);
    }

    @Override
    public void updateDataStore(DataStore dataStore) {
        this.updateServiceData(dataStore.getServiceId(), dataStore.getDataStoreId(), this.gson.toJson((Object)dataStore), this.dataStoreUpdate);
    }

    @Override
    public void deleteDataStore(String serviceId, String dataStoreId) {
        this.deleteServiceData(serviceId, dataStoreId, this.dataStoreDelete);
    }

    @Override
    public List<WorkItem> getWorkItems() {
        return this.getData("workItem", WorkItem.class);
    }

    @Override
    public WorkItem getWorkItem(String id) {
        return this.getData(id, this.workItemSelect, WorkItem.class);
    }

    @Override
    public void saveWorkItem(WorkItem workItem) {
        this.saveData(workItem.getId(), this.gson.toJson((Object)workItem), this.workItemInsert);
    }

    @Override
    public void deleteWorkItem(String id) {
        this.deleteData(id, this.workItemDelete);
    }

    @Override
    public int getWorkItemStatus(String id) {
        BoundStatement boundStatement = new BoundStatement(this.workItemStatusSelect);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{id}));
        Row row = results.one();
        if (row == null) {
            return -1;
        }
        return row.getInt("status");
    }

    @Override
    public void saveWorkItemStatus(String id, int status) {
        BoundStatement boundStatement = new BoundStatement(this.workItemStatusInsert);
        this.session.execute((Statement)boundStatement.bind(new Object[]{id, status}));
    }

    @Override
    public void saveAudit(Audit audit, String output) {
        audit.auditId = UUID.randomUUID().toString();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(audit.getTimePerformed());
        BoundStatement boundStatement = new BoundStatement(this.auditInsert);
        this.session.execute((Statement)boundStatement.bind(new Object[]{audit.serviceId, c.get(1), c.get(2) + 1, c.get(5), this.gson.toJson((Object)audit)}));
        if (output == null) {
            return;
        }
        if ((output = output.trim()).isEmpty()) {
            return;
        }
        boundStatement = new BoundStatement(this.auditOutputInsert);
        this.session.execute((Statement)boundStatement.bind(new Object[]{audit.serviceId, audit.auditId, output}));
    }

    @Override
    public List<Audit> getAudit(String serviceId, int year, int month, int startDay, int endDay) {
        LinkedList<Audit> audits = new LinkedList<Audit>();
        if (startDay < 1) {
            startDay = 1;
        }
        if (endDay < startDay) {
            endDay = startDay;
        }
        if (endDay > 31) {
            endDay = 31;
        }
        for (int day = startDay; day <= endDay; ++day) {
            BoundStatement boundStatement = new BoundStatement(this.auditSelect);
            ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, year, month, day}));
            for (Row row : results) {
                String data = row.getString("data");
                Audit audit = (Audit)this.gson.fromJson(data, Audit.class);
                if (audit.auditId == null) {
                    audit.auditId = UUID.randomUUID().toString();
                }
                audits.add(audit);
            }
        }
        return audits;
    }

    @Override
    public String getAuditOutput(String serviceId, String auditId) {
        BoundStatement boundStatement = new BoundStatement(this.auditOutputSelect);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, auditId}));
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            return row.getString("data");
        }
        return null;
    }

    @Override
    public SearchResult doSearch(String searchSpace, String searchText) {
        BoundStatement boundStatement = new BoundStatement(this.searchSelect);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{searchSpace, searchText.toLowerCase()}));
        if (results == null || results.isExhausted()) {
            return null;
        }
        Row row = results.one();
        SearchResult result = new SearchResult();
        result.searchSpace = searchSpace;
        result.searchText = searchText;
        result.serviceId = row.getString("serviceId");
        result.moduleId = row.getString("moduleId");
        result.hostId = row.getString("hostId");
        return result;
    }

    @Override
    public void insertSearch(String searchSpace, String searchText, String serviceId, String moduleId, String hostId) {
        SearchResult searchResult = this.doSearch(searchSpace, searchText);
        if (searchResult != null) {
            if (StringUtils.same(searchResult.serviceId, serviceId) && StringUtils.same(searchResult.moduleId, moduleId) && StringUtils.same(searchResult.hostId, hostId)) {
                return;
            }
            LOGGER.warn("Insert into search is really an update s:{} {} m:{} {} h:{} {}", new Object[]{searchResult.serviceId, serviceId, searchResult.moduleId, moduleId, searchResult.hostId, hostId});
        }
        BoundStatement boundStatement = new BoundStatement(this.searchInsert);
        this.session.execute((Statement)boundStatement.bind(new Object[]{searchSpace, searchText.toLowerCase(), serviceId, moduleId, hostId}));
    }

    @Override
    public void deleteSearch(String searchSpace, String searchText) {
        BoundStatement boundStatement = new BoundStatement(this.searchDelete);
        this.session.execute((Statement)boundStatement.bind(new Object[]{searchSpace, searchText.toLowerCase()}));
    }

    @Override
    public void updateSatus(String id, boolean busy, String status) {
        BoundStatement boundStatement = new BoundStatement(this.statusInsert);
        this.session.execute((Statement)boundStatement.bind(new Object[]{id, busy, status}));
    }

    private Row getStatus(String id) {
        BoundStatement boundStatement = new BoundStatement(this.statusSelect);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{id}));
        if (results == null || results.isExhausted()) {
            return null;
        }
        return results.one();
    }

    private <T> List<T> getData(String tableName, Class<T> classOfT) {
        ResultSet results = this.session.execute(CQL_SELECT_PRE + tableName + CQL_SELECT_POST);
        LinkedList<Object> listOfData = new LinkedList<Object>();
        for (Row row : results) {
            String data = row.getString("data");
            listOfData.add(this.gson.fromJson(data, classOfT));
        }
        return listOfData;
    }

    private <T> T getData(String id, PreparedStatement statement, Class<T> classOfT) {
        BoundStatement boundStatement = new BoundStatement(statement);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{id}));
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String data = row.getString("data");
            return (T)this.gson.fromJson(data, classOfT);
        }
        return null;
    }

    private void saveData(String id, String data, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{id, data}));
    }

    private void updateData(String id, String data, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{data, id}));
    }

    private void deleteData(String id, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{id}));
    }

    private <T> List<T> getServiceData(String serviceId, PreparedStatement statement, Class<T> classOfT) {
        BoundStatement boundStatement = new BoundStatement(statement);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId}));
        LinkedList<Object> listOfData = new LinkedList<Object>();
        for (Row row : results) {
            String data = row.getString("data");
            listOfData.add(this.gson.fromJson(data, classOfT));
        }
        return listOfData;
    }

    private <T> T getServiceData(String serviceId, String id, PreparedStatement statement, Class<T> classOfT) {
        BoundStatement boundStatement = new BoundStatement(statement);
        ResultSet results = this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, id}));
        Iterator iterator = results.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String data = row.getString("data");
            return (T)this.gson.fromJson(data, classOfT);
        }
        return null;
    }

    private void saveServiceData(String serviceId, String id, String data, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, id, data}));
    }

    private void updateServiceData(String serviceId, String id, String data, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{data, serviceId, id}));
    }

    private void deleteServiceData(String serviceId, String id, PreparedStatement statement) {
        BoundStatement boundStatement = new BoundStatement(statement);
        this.session.execute((Statement)boundStatement.bind(new Object[]{serviceId, id}));
    }

    public void close() {
        this.session.close();
    }
}

