/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.db;

import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Host;
import com.northernwall.hadrian.domain.Module;
import com.northernwall.hadrian.domain.Service;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataAccessUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAccessUpdater.class);

    public static void update(DataAccess dataAccess, Config config) {
        String version = dataAccess.getVersion();
        if (version == null || version.isEmpty()) {
            dataAccess.setVersion("1.7");
            LOGGER.info("New DB, initial version set.");
        } else {
            LOGGER.info("Current DB version is {}, no upgrade required.", (Object)version);
        }
        DataAccessUpdater.fixHost(dataAccess);
    }

    private static void fixHost(DataAccess dataAccess) {
        int serviceCount = 0;
        int hostCount = 0;
        List<Service> services = dataAccess.getActiveServices();
        if (services != null && !services.isEmpty()) {
            for (Service service : services) {
                List<Host> hosts;
                List<Module> modules;
                dataAccess.insertSearch("serviceName", service.getServiceName(), service.getServiceId(), null, null);
                if (service.getGitProject() != null && !service.getGitProject().isEmpty()) {
                    dataAccess.insertSearch("gitProject", service.getGitProject(), service.getServiceId(), null, null);
                }
                ++serviceCount;
                if (service.getMavenGroupId() != null && !service.getMavenGroupId().isEmpty() && (modules = dataAccess.getModules(service.getServiceId())) != null && !modules.isEmpty()) {
                    for (Module module : modules) {
                        if (module.getMavenArtifactId() == null || module.getMavenArtifactId().isEmpty()) continue;
                        dataAccess.insertSearch("mavenGroupArtifact", service.getMavenGroupId() + "." + module.getMavenArtifactId(), service.getServiceId(), module.getModuleId(), null);
                    }
                }
                if ((hosts = dataAccess.getHosts(service.getServiceId())) == null || hosts.isEmpty()) continue;
                for (Host host : hosts) {
                    dataAccess.insertSearch("hostName", host.getHostName(), service.getServiceId(), host.getModuleId(), host.getHostId());
                    ++hostCount;
                }
            }
        }
        LOGGER.info("Backfilled {} service, {} hosts", (Object)serviceCount, (Object)hostCount);
    }

    private DataAccessUpdater() {
    }
}

