/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.calendar.google;

import com.google.api.client.util.DateTime;
import com.google.api.services.calendar.Calendar;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.EventDateTime;
import com.google.api.services.calendar.model.Events;
import com.northernwall.hadrian.GMT;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.domain.CalendarEntry;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.parameters.Parameters;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCalendarHelper
extends CalendarHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleCalendarHelper.class);
    private final Calendar calendarClient;
    private final Parameters parameters;

    public GoogleCalendarHelper(Calendar calendarClient, Parameters parameters) {
        this.calendarClient = calendarClient;
        this.parameters = parameters;
    }

    @Override
    public List<CalendarEntry> getCalendarEntries(Team team) {
        LinkedList<CalendarEntry> entries = new LinkedList<CalendarEntry>();
        String calendarId = this.parameters.getString("calendarHelper.google.globalCalendarId", null);
        if (calendarId != null) {
            this.getEntriesForCalendar(calendarId, entries);
        }
        if (team != null && team.getCalendarId() != null) {
            this.getEntriesForCalendar(team.getCalendarId(), entries);
        }
        Collections.sort(entries);
        return entries;
    }

    private void getEntriesForCalendar(String calendarId, List<CalendarEntry> entries) {
        long now = GMT.getGmtAsLong();
        try {
            DateTime timeMin = new DateTime(now, 0);
            DateTime timeMax = new DateTime(now + 86400000L + 3600000L, 0);
            Events events = (Events)this.calendarClient.events().list(calendarId).setTimeMin(timeMin).setTimeMax(timeMax).execute();
            List eventsList = events.getItems();
            if (eventsList != null && !eventsList.isEmpty()) {
                for (Event event : eventsList) {
                    if (event.getRecurrence() == null || event.getRecurrence().isEmpty()) {
                        this.processEvent(event, now, entries);
                        continue;
                    }
                    Events recurringEvents = (Events)this.calendarClient.events().instances(calendarId, event.getId()).setTimeMin(timeMin).setTimeMax(timeMax).execute();
                    List recurringEventsList = recurringEvents.getItems();
                    if (recurringEventsList == null || recurringEventsList.isEmpty()) continue;
                    for (Event recurringEvent : recurringEventsList) {
                        this.processEvent(recurringEvent, now, entries);
                    }
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("IO Exception while getting calendar entries, {}", (Object)ex.getMessage());
        }
    }

    private void processEvent(Event event, long now, List<CalendarEntry> entries) {
        long start = this.getDateTime(event.getStart());
        long end = this.getDateTime(event.getEnd());
        if (end != 0L && start != 0L && end > now) {
            CalendarEntry entry = new CalendarEntry();
            entry.calendarName = event.getOrganizer().getDisplayName();
            entry.startTime = start;
            entry.starts = GoogleCalendarHelper.buildStartsEndsText(start);
            entry.ends = GoogleCalendarHelper.buildStartsEndsText(end);
            entry.description = event.getSummary();
            entries.add(entry);
        }
    }

    private long getDateTime(EventDateTime eventDateTime) {
        if (eventDateTime.getDateTime() != null) {
            return eventDateTime.getDateTime().getValue();
        }
        if (eventDateTime.getDate() != null) {
            return eventDateTime.getDate().getValue();
        }
        return 0L;
    }
}

