/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian.access.simple;

import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.domain.Team;
import com.northernwall.hadrian.domain.User;
import com.northernwall.hadrian.handlers.routing.Http401UnauthorizedException;
import com.northernwall.hadrian.handlers.routing.Http404NotFoundException;
import com.northernwall.hadrian.parameters.Parameters;
import org.eclipse.jetty.server.Request;

public class SimpleAccessHelper
implements AccessHelper {
    private final Parameters parameters;

    public SimpleAccessHelper(Parameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public User getUser(String username) {
        return new User(username);
    }

    @Override
    public boolean canUserModify(Request request, Team team) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user");
        }
        return this.isInGroup(user, "group.team." + team.getSecurityGroupName());
    }

    @Override
    public User checkIfUserCanModify(Request request, Team team, String action) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to " + action);
        }
        String username = user.getUsername();
        if (!this.isInGroup(user, "group.team." + team.getSecurityGroupName())) {
            throw new Http401UnauthorizedException(username + " attempted to " + action + " on team " + team.getTeamName());
        }
        return user;
    }

    @Override
    public User checkIfUserCanDeploy(Request request, Team team) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to deploy software to host");
        }
        if (this.isInGroup(user, "group.deploy")) {
            return user;
        }
        String username = user.getUsername();
        if (!this.isInGroup(user, "group.team." + team.getSecurityGroupName())) {
            throw new Http401UnauthorizedException(username + " attempted to deploy software to host on team " + team.getTeamName());
        }
        return user;
    }

    @Override
    public User checkIfUserCanRestart(Request request, Team team) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to restart host");
        }
        if (this.isInGroup(user, "group.deploy") || this.isInGroup(user, "group.admin")) {
            return user;
        }
        String username = user.getUsername();
        if (!this.isInGroup(user, "group.team." + team.getSecurityGroupName())) {
            throw new Http401UnauthorizedException(username + " attempted to restart host on team " + team.getTeamName());
        }
        return user;
    }

    @Override
    public User checkIfUserCanAudit(Request request, Team team) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown user attempted to add audit record");
        }
        if (this.isInGroup(user, "group.audit")) {
            return user;
        }
        String username = user.getUsername();
        if (!this.isInGroup(user, "group.team." + team.getSecurityGroupName())) {
            throw new Http401UnauthorizedException(username + " attempted to add audit record on team " + team.getTeamName());
        }
        return user;
    }

    @Override
    public boolean isAdmin(Request request, String action) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown users attempted to " + action + " but is not an admin");
        }
        return this.isInGroup(user, "group.admin");
    }

    @Override
    public User checkIfUserIsAdmin(Request request, String action) {
        User user = (User)request.getAttribute("user");
        if (user == null) {
            throw new Http404NotFoundException("unknown users attempted to " + action + " but is not an admin");
        }
        if (!this.isInGroup(user, "group.admin")) {
            throw new Http401UnauthorizedException(user.getUsername() + " attempted to " + action + " but is not an admin");
        }
        return user;
    }

    private boolean isInGroup(User user, String groupName) {
        String[] userNames;
        String parameter = this.parameters.getString(groupName, null);
        if (parameter == null || parameter.isEmpty()) {
            return false;
        }
        for (String userName : userNames = parameter.split(",")) {
            if (!userName.equalsIgnoreCase(user.getUsername())) continue;
            return true;
        }
        return false;
    }
}

