/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.northernwall.hadrian.HadrianBuilder;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.parameters.PropertiesParameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.LoggerFactory;

public class Main {
    public static void main(String[] args) {
        try {
            Parameters parameters = Main.loadParameters(args);
            Main.startLogging(parameters);
            HadrianBuilder.create(parameters).builder().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Parameters loadParameters(String[] args) {
        String filename;
        Properties properties = new Properties();
        if (args == null || args.length == 0) {
            System.out.println("Missing command line argument properties filename, using hadrian.properties");
            filename = "hadrian.properties";
        } else {
            filename = args[0];
        }
        try {
            properties.load(new FileInputStream(filename));
        }
        catch (IOException ex) {
            System.out.println("Can not load properties from " + filename + ", using defaults");
            properties = new Properties();
        }
        return new PropertiesParameters(properties);
    }

    private static void startLogging(Parameters parameters) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)context);
        context.reset();
        try {
            String config = parameters.getString("logback.config", null);
            if (config != null && !config.isEmpty()) {
                System.out.println("Loading logback config from parameter value");
                configurator.doConfigure(config);
                StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
                return;
            }
            String filename = parameters.getString("logback.filename", "logback.xml");
            File file = new File(filename);
            if (file.exists()) {
                System.out.println("Loading logback config from file, " + filename);
                configurator.doConfigure(file);
                StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
                return;
            }
            System.out.println("Can not load logback config from parameter value or file, using defaults");
            configurator.doConfigure(Main.class.getResourceAsStream("/logback.xml"));
        }
        catch (JoranException je) {
            System.out.println("Could not find/load logback config file, exiting");
            System.out.println("Joran exception is " + je.getMessage());
            System.exit(0);
        }
    }
}

