/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian;

import com.google.gson.Gson;
import com.northernwall.hadrian.ConfigHelper;
import com.northernwall.hadrian.access.AccessHelper;
import com.northernwall.hadrian.calendar.CalendarHelper;
import com.northernwall.hadrian.db.DataAccess;
import com.northernwall.hadrian.details.HostDetailsHelper;
import com.northernwall.hadrian.details.ServiceBuildHelper;
import com.northernwall.hadrian.details.VipDetailsHelper;
import com.northernwall.hadrian.handlers.caching.ContentHandler;
import com.northernwall.hadrian.handlers.dashboard.DashboardHandler;
import com.northernwall.hadrian.handlers.graph.GraphAllHandler;
import com.northernwall.hadrian.handlers.graph.GraphFanInHandler;
import com.northernwall.hadrian.handlers.graph.GraphFanOutHandler;
import com.northernwall.hadrian.handlers.host.HostBackfillHandler;
import com.northernwall.hadrian.handlers.host.HostCreateHandler;
import com.northernwall.hadrian.handlers.host.HostDeleteHandler;
import com.northernwall.hadrian.handlers.host.HostDeploySoftwareHandler;
import com.northernwall.hadrian.handlers.host.HostFindHandler;
import com.northernwall.hadrian.handlers.host.HostGetDetailsHandler;
import com.northernwall.hadrian.handlers.host.HostRestartHandler;
import com.northernwall.hadrian.handlers.module.ModuleCreateHandler;
import com.northernwall.hadrian.handlers.module.ModuleDeleteHandler;
import com.northernwall.hadrian.handlers.module.ModuleFileCreateHandler;
import com.northernwall.hadrian.handlers.module.ModuleFileDeleteHandler;
import com.northernwall.hadrian.handlers.module.ModuleFileGetHandler;
import com.northernwall.hadrian.handlers.module.ModuleModifyHandler;
import com.northernwall.hadrian.handlers.report.ReportHandler;
import com.northernwall.hadrian.handlers.routing.MethodRule;
import com.northernwall.hadrian.handlers.routing.RoutingHandler;
import com.northernwall.hadrian.handlers.routing.TargetRule;
import com.northernwall.hadrian.handlers.service.AuditCreateHandler;
import com.northernwall.hadrian.handlers.service.AuditGetHandler;
import com.northernwall.hadrian.handlers.service.AuditOutputGetHandler;
import com.northernwall.hadrian.handlers.service.CalendarGetHandler;
import com.northernwall.hadrian.handlers.service.ConfigGetHandler;
import com.northernwall.hadrian.handlers.service.CustomFuntionCreateHandler;
import com.northernwall.hadrian.handlers.service.CustomFuntionDeleteHandler;
import com.northernwall.hadrian.handlers.service.CustomFuntionExecHandler;
import com.northernwall.hadrian.handlers.service.CustomFuntionModifyHandler;
import com.northernwall.hadrian.handlers.service.DataStoreGetHandler;
import com.northernwall.hadrian.handlers.service.DocumentCreateHandler;
import com.northernwall.hadrian.handlers.service.DocumentDeleteHandler;
import com.northernwall.hadrian.handlers.service.DocumentGetHandler;
import com.northernwall.hadrian.handlers.service.ServiceBuildHandler;
import com.northernwall.hadrian.handlers.service.ServiceCreateHandler;
import com.northernwall.hadrian.handlers.service.ServiceDeleteHandler;
import com.northernwall.hadrian.handlers.service.ServiceGetHandler;
import com.northernwall.hadrian.handlers.service.ServiceModifyHandler;
import com.northernwall.hadrian.handlers.service.ServiceNotUsesGetHandler;
import com.northernwall.hadrian.handlers.service.ServiceRefCreateHandler;
import com.northernwall.hadrian.handlers.service.ServiceRefDeleteHandler;
import com.northernwall.hadrian.handlers.service.ServiceRefreshHandler;
import com.northernwall.hadrian.handlers.service.ServiceResetAllHandler;
import com.northernwall.hadrian.handlers.service.ServiceTransferHandler;
import com.northernwall.hadrian.handlers.service.ServicesGetHandler;
import com.northernwall.hadrian.handlers.service.SmokeTestExecHandler;
import com.northernwall.hadrian.handlers.service.VersionsGetHandler;
import com.northernwall.hadrian.handlers.service.helper.FolderHelper;
import com.northernwall.hadrian.handlers.service.helper.InfoHelper;
import com.northernwall.hadrian.handlers.team.TeamCreateHandler;
import com.northernwall.hadrian.handlers.team.TeamGetHandler;
import com.northernwall.hadrian.handlers.team.TeamModifyHandler;
import com.northernwall.hadrian.handlers.team.TeamsGetHandler;
import com.northernwall.hadrian.handlers.tree.CatalogHandler;
import com.northernwall.hadrian.handlers.tree.TreeHandler;
import com.northernwall.hadrian.handlers.utility.AvailabilityHandler;
import com.northernwall.hadrian.handlers.utility.ConvertHandler;
import com.northernwall.hadrian.handlers.utility.FaviconHandler;
import com.northernwall.hadrian.handlers.utility.HealthHandler;
import com.northernwall.hadrian.handlers.utility.MetricHandler;
import com.northernwall.hadrian.handlers.utility.RedirectHandler;
import com.northernwall.hadrian.handlers.utility.VersionHandler;
import com.northernwall.hadrian.handlers.vip.VipBackfillHandler;
import com.northernwall.hadrian.handlers.vip.VipCreateHandler;
import com.northernwall.hadrian.handlers.vip.VipDeleteHandler;
import com.northernwall.hadrian.handlers.vip.VipGetDetailsHandler;
import com.northernwall.hadrian.handlers.vip.VipMigrateHandler;
import com.northernwall.hadrian.handlers.vip.VipModifyHandler;
import com.northernwall.hadrian.handlers.workitem.WorkItemGetHandler;
import com.northernwall.hadrian.messaging.MessageSendHandler;
import com.northernwall.hadrian.messaging.MessagingCoodinator;
import com.northernwall.hadrian.module.ModuleArtifactHelper;
import com.northernwall.hadrian.module.ModuleConfigHelper;
import com.northernwall.hadrian.parameters.Parameters;
import com.northernwall.hadrian.schedule.Scheduler;
import com.northernwall.hadrian.workItem.WorkItemCallbackHandler;
import com.northernwall.hadrian.workItem.WorkItemProcessor;
import com.northernwall.hadrian.workItem.helper.SmokeTestHelper;
import com.squareup.okhttp.OkHttpClient;
import java.net.BindException;
import org.dshops.metrics.MetricRegistry;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadrian {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hadrian.class);
    private final Parameters parameters;
    private final OkHttpClient client;
    private final ConfigHelper configHelper;
    private final DataAccess dataAccess;
    private final ModuleArtifactHelper moduleArtifactHelper;
    private final ModuleConfigHelper moduleConfigHelper;
    private final AccessHelper accessHelper;
    private final Handler accessHandler;
    private final HostDetailsHelper hostDetailsHelper;
    private final VipDetailsHelper vipDetailsHelper;
    private final CalendarHelper calendarHelper;
    private final WorkItemProcessor workItemProcessor;
    private final Scheduler scheduler;
    private final FolderHelper folderHelper;
    private final SmokeTestHelper smokeTestHelper;
    private final MetricRegistry metricRegistry;
    private final MessagingCoodinator messagingCoodinator;
    private final Gson gson;
    private final InfoHelper infoHelper;
    private int port;
    private Server server;

    Hadrian(Parameters parameters, OkHttpClient client, ConfigHelper configHelper, DataAccess dataAccess, ModuleArtifactHelper moduleArtifactHelper, ModuleConfigHelper moduleConfigHelper, AccessHelper accessHelper, Handler accessHandler, HostDetailsHelper hostDetailsHelper, VipDetailsHelper vipDetailsHelper, CalendarHelper calendarHelper, WorkItemProcessor workItemProcessor, Scheduler scheduler, FolderHelper folderHelper, SmokeTestHelper smokeTestHelper, MetricRegistry metricRegistry, MessagingCoodinator messagingCoodinator, Gson gson) {
        this.parameters = parameters;
        this.client = client;
        this.configHelper = configHelper;
        this.dataAccess = dataAccess;
        this.moduleArtifactHelper = moduleArtifactHelper;
        this.moduleConfigHelper = moduleConfigHelper;
        this.accessHelper = accessHelper;
        this.accessHandler = accessHandler;
        this.hostDetailsHelper = hostDetailsHelper;
        this.vipDetailsHelper = vipDetailsHelper;
        this.calendarHelper = calendarHelper;
        this.workItemProcessor = workItemProcessor;
        this.scheduler = scheduler;
        this.folderHelper = folderHelper;
        this.smokeTestHelper = smokeTestHelper;
        this.metricRegistry = metricRegistry;
        this.messagingCoodinator = messagingCoodinator;
        this.gson = gson;
        this.infoHelper = new InfoHelper(parameters, client);
        this.setupJetty();
    }

    private void setupJetty() {
        this.port = this.parameters.getInt("jetty.port", 9090);
        this.server = new Server((ThreadPool)new QueuedThreadPool(50, 5));
        this.server.setStopAtShutdown(true);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{httpFactory});
        connector.setPort(this.port);
        connector.setIdleTimeout((long)this.parameters.getInt("jetty.idleTimeout", 5000));
        connector.setAcceptQueueSize(this.parameters.getInt("jetty.acceptQueueSize", 100));
        this.server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        RoutingHandler routingHandler = new RoutingHandler();
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/availability", (Handler)new AvailabilityHandler(this.dataAccess), false);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/version", (Handler)new VersionHandler(), false);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/health", (Handler)new HealthHandler(this.accessHandler, this.calendarHelper, this.dataAccess, this.moduleArtifactHelper, this.moduleConfigHelper, this.parameters, this.messagingCoodinator, this.scheduler), true);
        ContentHandler contentHandler = new ContentHandler("/webcontent");
        contentHandler.preload("/js/viz.js");
        contentHandler.preload("/js/angular.js");
        contentHandler.preload("/js/angular-animate.js");
        contentHandler.preload("/js/ace.js");
        contentHandler.preload("/js/ui-bootstrap-tpls-0.14.2.min.js");
        contentHandler.preload("/css/bootstrap.min.css");
        routingHandler.add(MethodRule.GET, TargetRule.STARTS_WITH, "/ui/", (Handler)contentHandler, false);
        routingHandler.add(MethodRule.POST, TargetRule.STARTS_WITH, "/webhook/callback", (Handler)new WorkItemCallbackHandler(this.gson, this.workItemProcessor), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/favicon.ico", (Handler)new FaviconHandler(), false);
        routingHandler.add(MethodRule.ANY, TargetRule.ANY, "/", this.accessHandler, false);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/config", (Handler)new ConfigGetHandler(this.configHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.STARTS_WITH, "/ui/", (Handler)new ContentHandler("/webapp"), false);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/tree", (Handler)new TreeHandler(this.dataAccess, this.accessHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/catalog", (Handler)new CatalogHandler(this.dataAccess), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/report", (Handler)new ReportHandler(this.accessHelper, this.dataAccess, this.configHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/team", (Handler)new TeamGetHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/teams", (Handler)new TeamsGetHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/team/create", (Handler)new TeamCreateHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/team/modify", (Handler)new TeamModifyHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/dashboard", (Handler)new DashboardHandler(this.dataAccess, this.gson, this.infoHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/services", (Handler)new ServicesGetHandler(this.dataAccess), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/service", (Handler)new ServiceGetHandler(this.dataAccess, this.gson, this.accessHelper, this.configHelper, this.infoHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/service/refresh", (Handler)new ServiceRefreshHandler(this.dataAccess, this.gson, this.accessHelper, this.configHelper, this.infoHelper), false);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/service/version", (Handler)new VersionsGetHandler(this.dataAccess, this.gson, this.moduleArtifactHelper, this.moduleConfigHelper, this.configHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/service/notuses", (Handler)new ServiceNotUsesGetHandler(this.dataAccess), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/service/audit", (Handler)new AuditGetHandler(this.dataAccess, this.gson), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/service/auditOutput", (Handler)new AuditOutputGetHandler(this.dataAccess, this.gson), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/create", (Handler)new ServiceCreateHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/modify", (Handler)new ServiceModifyHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/resetAll", (Handler)new ServiceResetAllHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/delete", (Handler)new ServiceDeleteHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/createRef", (Handler)new ServiceRefCreateHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/deleteRef", (Handler)new ServiceRefDeleteHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/build", (Handler)new ServiceBuildHandler(this.dataAccess, this.gson, this.accessHelper, new ServiceBuildHelper(this.dataAccess, this.client, this.parameters, this.gson)), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/service/transfer", (Handler)new ServiceTransferHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/vip/details", (Handler)new VipGetDetailsHandler(this.dataAccess, this.gson, this.vipDetailsHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/vip/create", (Handler)new VipCreateHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/vip/backfill", (Handler)new VipBackfillHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/vip/modify", (Handler)new VipModifyHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/vip/delete", (Handler)new VipDeleteHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/vip/migrate", (Handler)new VipMigrateHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/module/file", (Handler)new ModuleFileGetHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/module/create", (Handler)new ModuleCreateHandler(this.dataAccess, this.gson, this.accessHelper, this.configHelper, this.workItemProcessor, this.folderHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/module/modify", (Handler)new ModuleModifyHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor, this.folderHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/module/file", (Handler)new ModuleFileCreateHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.DELETE, TargetRule.EQUALS, "/v1/module/file", (Handler)new ModuleFileDeleteHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/module/delete", (Handler)new ModuleDeleteHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/host/details", (Handler)new HostGetDetailsHandler(this.dataAccess, this.gson, this.hostDetailsHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/host/find", (Handler)new HostFindHandler(this.dataAccess, this.gson, this.infoHelper, this.hostDetailsHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/create", (Handler)new HostCreateHandler(this.dataAccess, this.gson, this.accessHelper, this.configHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/deploy", (Handler)new HostDeploySoftwareHandler(this.dataAccess, this.gson, this.accessHelper, this.configHelper, this.infoHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/restart", (Handler)new HostRestartHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/delete", (Handler)new HostDeleteHandler(this.dataAccess, this.gson, this.accessHelper, this.workItemProcessor), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/host/backfill", (Handler)new HostBackfillHandler(this.dataAccess, this.gson, this.accessHelper, this.configHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/st/exec", (Handler)new SmokeTestExecHandler(this.dataAccess, this.gson, this.accessHelper, this.smokeTestHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/cf/exec", (Handler)new CustomFuntionExecHandler(this.dataAccess, this.gson, this.accessHelper, this.client), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/cf/create", (Handler)new CustomFuntionCreateHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/cf/modify", (Handler)new CustomFuntionModifyHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/cf/delete", (Handler)new CustomFuntionDeleteHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/document/create", (Handler)new DocumentCreateHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/document/delete", (Handler)new DocumentDeleteHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/document", (Handler)new DocumentGetHandler(this.dataAccess, this.gson, this.client, this.parameters), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/workitems", (Handler)new WorkItemGetHandler(this.dataAccess), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/datastore", (Handler)new DataStoreGetHandler(), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/calendar", (Handler)new CalendarGetHandler(this.dataAccess, this.gson, this.calendarHelper), true);
        routingHandler.add(MethodRule.GET, TargetRule.EQUALS, "/v1/graph/all", (Handler)new GraphAllHandler(this.dataAccess), true);
        routingHandler.add(MethodRule.GET, TargetRule.MATCHES, "/v1/graph/fanin/\\w+-\\w+-\\w+-\\w+-\\w+", (Handler)new GraphFanInHandler(this.dataAccess), true);
        routingHandler.add(MethodRule.GET, TargetRule.MATCHES, "/v1/graph/fanout/\\w+-\\w+-\\w+-\\w+-\\w+", (Handler)new GraphFanOutHandler(this.dataAccess), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/audit", (Handler)new AuditCreateHandler(this.dataAccess, this.gson, this.accessHelper), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/sendMessage", (Handler)new MessageSendHandler(this.dataAccess, this.gson, this.accessHelper, this.messagingCoodinator), true);
        routingHandler.add(MethodRule.PUTPOST, TargetRule.EQUALS, "/v1/convert", (Handler)new ConvertHandler(this.dataAccess, this.gson, this.accessHelper, this.configHelper), true);
        routingHandler.add(MethodRule.ANY, TargetRule.ANY, "/", (Handler)new RedirectHandler(), true);
        handlers.addHandler((Handler)routingHandler);
        MetricHandler metricHandler = new MetricHandler(handlers, this.metricRegistry);
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setHandler((Handler)metricHandler);
        contextHandler.setContextPath("/");
        this.server.setHandler((Handler)contextHandler);
    }

    public void start() {
        try {
            this.server.start();
            LOGGER.info("Jetty server started on port {}, joining with server thread now", (Object)this.port);
            this.server.join();
        }
        catch (BindException be) {
            LOGGER.error("Can not bind to port {}, exiting", (Object)this.port);
            System.exit(0);
        }
        catch (Exception ex) {
            LOGGER.error("Exception {} occured", (Object)ex.getMessage());
        }
    }
}

