/*
 * Decompiled with CFR 0.152.
 */
package com.northernwall.hadrian;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.northernwall.hadrian.domain.Config;
import com.northernwall.hadrian.domain.Environment;
import com.northernwall.hadrian.module.ModuleConfigHelper;
import com.northernwall.hadrian.parameters.ParameterChangeListener;
import com.northernwall.hadrian.parameters.Parameters;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHelper
implements ParameterChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigHelper.class);
    private final Parameters parameters;
    private final Gson gson;
    private final ModuleConfigHelper moduleConfigHelper;
    private final AtomicReference<Config> config;

    public ConfigHelper(Parameters parameters, Gson gson, ModuleConfigHelper moduleConfigHelper) {
        this.parameters = parameters;
        this.gson = gson;
        this.moduleConfigHelper = moduleConfigHelper;
        this.config = new AtomicReference();
        this.config.set(this.loadConfig());
        parameters.registerChangeListener(this);
    }

    public Config getConfig() {
        return this.config.get();
    }

    @Override
    public void onChange(List<String> keys) {
        this.config.set(this.loadConfig());
    }

    private Config loadConfig() {
        Config newConfig = new Config();
        newConfig.mavenGroupId = this.parameters.getString("config.mavenGroupId", "");
        newConfig.versionUrl = this.parameters.getString("config.versionUrl", "{host}.mydomain.com:9090/version");
        newConfig.availabilityUrl = this.parameters.getString("config.availabilityUrl", "{host}.mydomain.com:9090/availability");
        newConfig.smokeTestUrl = this.parameters.getString("config.smokeTestUrl", "service.mydomain.com:9090/smokeTest?endPoint={endPoint}");
        newConfig.deploymentFolder = this.parameters.getString("config.deploymentFolder", "/home/app");
        newConfig.dataFolder = this.parameters.getString("config.dataFolder", "/var/app/data");
        newConfig.logsFolder = this.parameters.getString("config.logsFolder", "/var/app/logs");
        newConfig.gitUiURL = this.parameters.getString("gitUiUrl", "http://127.0.0.1/");
        newConfig.securityGroupName = this.parameters.getString("config.securityGroupName", "Security Group");
        newConfig.moduleConfigName = this.moduleConfigHelper == null ? "Config Name" : this.moduleConfigHelper.getDisplayName();
        newConfig.enableHostProvisioning = this.parameters.getBoolean("config.enableHostProvisioning", false);
        newConfig.enableVipProvisioning = this.parameters.getBoolean("config.enableVipProvisioning", false);
        newConfig.enableVipMigration = this.parameters.getBoolean("config.enableVipMigration", false);
        this.loadConfig("config.dataCenters", "dc", newConfig.dataCenters);
        this.loadConfig("config.platforms", "Java7, Java8", newConfig.platforms);
        this.loadConfig("config.protocols", "HTTP, HTTPS, TCP", newConfig.protocols);
        this.loadConfig("config.domains", "northernwall.com", newConfig.domains);
        this.loadConfig("config.artifactTypes", "jar, war, targz", newConfig.artifactTypes);
        this.loadConfig("config.scopes", "Not in scope, In scope", newConfig.scopes);
        this.loadEnvironment(newConfig);
        this.loadFolderWhiteList(this.parameters.getString("config.folderWhiteList", null), newConfig.folderWhiteList);
        LOGGER.info("Config loaded, {}", (Object)this.gson.toJson((Object)newConfig));
        return newConfig;
    }

    private void loadConfig(String key, String defaultValue, List<String> target) {
        String[] parts;
        String param = this.parameters.getString(key, defaultValue);
        if (param == null) {
            return;
        }
        for (String part : parts = param.split(",")) {
            String temp = part.trim();
            if (temp.isEmpty()) continue;
            target.add(temp);
        }
    }

    private void loadEnvironment(Config newConfig) {
        String temp = this.parameters.getString("config.environments", "[{\"name\":\"Prod\",\"pattern\":\"{dc}-prd-{abbr}-\",\"warning\":\"Please be aware that your change will affect Production.\"},{\"name\":\"CIE\",\"pattern\":\"{dc}-cie-{abbr}-\"},{\"name\":\"Sandbox\",\"pattern\":\"{dc}-tst-{abbr}-\"},{\"name\":\"Reg\",\"pattern\":\"{dc}-tst-{abbr}reg-\",\"allowUrl\":true}]");
        Type listType = new TypeToken<ArrayList<Environment>>(){}.getType();
        newConfig.environments = (List)this.gson.fromJson(temp, listType);
        for (Environment environment : newConfig.environments) {
            newConfig.environmentNames.add(environment.name);
        }
    }

    private void loadFolderWhiteList(String temp, List<String> folderWhiteList) {
        String[] folders;
        if (temp == null || temp.isEmpty()) {
            return;
        }
        for (String folder : folders = temp.split(",")) {
            String tempFolder = folder.trim();
            if (tempFolder.isEmpty() || tempFolder.equals("/")) continue;
            if (!tempFolder.startsWith("/")) {
                tempFolder = "/" + tempFolder;
            }
            if (!tempFolder.endsWith("/") && tempFolder.length() > 1) {
                tempFolder = tempFolder + "/";
            }
            folderWhiteList.add(tempFolder);
        }
    }
}

