/*
 * Decompiled with CFR 0.152.
 */
package org.dsh.metrics.listeners;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.dsh.metrics.DoubleEvent;
import org.dsh.metrics.Event;
import org.dsh.metrics.EventListener;
import org.dsh.metrics.LongEvent;
import org.kairosdb.client.HttpClient;
import org.kairosdb.client.builder.MetricBuilder;

public class KairosDBListener
implements EventListener,
Runnable {
    private final BlockingQueue<Event> queue = new ArrayBlockingQueue<Event>(1000);
    private final int batchSize;
    private final long offerTime;
    private Thread runThread;
    private final HttpClient kairosDb;

    public KairosDBListener(String connectString, String un, String pd) {
        this(connectString, un, pd, 100);
    }

    public KairosDBListener(String connectString, String un, String pd, int batchSize) {
        this(connectString, un, pd, batchSize, -1L);
    }

    public KairosDBListener(String connectString, String un, String pd, int batchSize, long offerTimeMillis) {
        this.batchSize = batchSize > 1 ? batchSize : 100;
        this.offerTime = offerTimeMillis;
        try {
            this.kairosDb = new HttpClient(connectString);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Malformed Url:" + connectString + " " + mue.getMessage());
        }
        this.runThread = new Thread(this);
        this.runThread.setName("kairosDbListener");
        this.runThread.setDaemon(true);
        this.runThread.start();
    }

    @Override
    public void run() {
        ArrayList<Event> dispatchList = new ArrayList<Event>(100);
        while (true) {
            try {
                dispatchList.add(this.queue.take());
                this.queue.drainTo(dispatchList, this.batchSize - 1);
                this.kairosDb.pushMetrics(this.buildPayload(dispatchList));
            }
            catch (InterruptedException ie) {
                break;
            }
            catch (Exception exception) {}
            continue;
            finally {
                dispatchList.clear();
                continue;
            }
            break;
        }
    }

    private MetricBuilder buildPayload(List<Event> events) {
        MetricBuilder mb = MetricBuilder.getInstance();
        for (Event e : events) {
            if (e instanceof LongEvent) {
                mb.addMetric(e.getName()).addTags(e.getTags()).addDataPoint(e.getTimestamp(), e.getLongValue());
                continue;
            }
            if (e instanceof DoubleEvent) {
                mb.addMetric(e.getName()).addTags(e.getTags()).addDataPoint(e.getTimestamp(), e.getDoubleValue());
                continue;
            }
            mb.addMetric(e.getName()).addTags(e.getTags()).addDataPoint(e.getTimestamp(), 1L);
        }
        return mb;
    }

    @Override
    public int eventsBuffered() {
        return this.queue.size();
    }

    @Override
    public void onEvent(Event e) {
        if (this.offerTime > 0L) {
            try {
                this.queue.offer(e, this.offerTime, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.queue.offer(e);
        }
    }
}

