/*
 * Decompiled with CFR 0.152.
 */
package org.dsh.metrics;

import java.util.HashMap;
import java.util.Map;
import org.dsh.metrics.MetricBase;
import org.dsh.metrics.MetricRegistry;
import org.dsh.metrics.Util;

public class Timer
extends MetricBase {
    private long startTime;

    Timer(String name, MetricRegistry registry) {
        super(name, registry, null);
    }

    Timer(String name, MetricRegistry registry, Map<String, String> customTags) {
        super(name, registry, customTags);
    }

    Timer start() {
        this.startTime = System.currentTimeMillis();
        return this;
    }

    public long stop() {
        long duration = System.currentTimeMillis() - this.startTime;
        this.registry.postEvent(this.name, this.startTime, this.tags, duration);
        return duration;
    }

    public long stop(String ... tags) {
        return this.stop(Util.buildTags(tags));
    }

    public long stop(Map<String, String> tags) {
        long duration = System.currentTimeMillis() - this.startTime;
        if (this.tags == null) {
            this.tags = new HashMap();
        }
        this.tags.putAll(tags);
        this.registry.postEvent(this.name, this.startTime, tags, duration);
        return duration;
    }

    public static class Builder {
        private Timer timer;

        Builder(String name, MetricRegistry registry) {
            this.timer = new Timer(name, registry, new HashMap<String, String>());
        }

        public Builder addTag(String name, String value) {
            this.timer.tags.put(name, value);
            return this;
        }

        public Timer build() {
            return this.timer.start();
        }
    }
}

