/*
 * Decompiled with CFR 0.152.
 */
package org.dsh.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dsh.metrics.DoubleEvent;
import org.dsh.metrics.Event;
import org.dsh.metrics.EventImpl;
import org.dsh.metrics.EventListener;
import org.dsh.metrics.Gauge;
import org.dsh.metrics.GaugeRunner;
import org.dsh.metrics.LongEvent;
import org.dsh.metrics.MetricKey;
import org.dsh.metrics.Timer;
import org.dsh.metrics.Util;

public class MetricRegistry {
    private final String prefix;
    private final Map<String, String> tags;
    private final Map<MetricKey, Gauge> gauges = new ConcurrentHashMap<MetricKey, Gauge>();
    private final List<EventListener> listeners = new CopyOnWriteArrayList<EventListener>();
    private final ScheduledThreadPoolExecutor pools = new ScheduledThreadPoolExecutor(10);

    MetricRegistry(String prefix, Map<String, String> tags) {
        this.prefix = prefix;
        this.tags = tags;
    }

    MetricRegistry(String prefix) {
        this.prefix = prefix;
        this.tags = null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public Timer timer(String name) {
        return new Timer(name, this).start();
    }

    public Timer.Builder timerWithTags(String name) {
        return new Timer.Builder(name, this);
    }

    public Timer timer(String name, String ... tags) {
        return this.timer(name, Util.buildTags(tags));
    }

    public Timer timer(String name, Map<String, String> tags) {
        return new Timer(name, this, tags).start();
    }

    public void event(String name) {
        this.event_(name, 1L, null);
    }

    public void event(String name, String ... customTags) {
        this.event_(name, 1L, Util.buildTags(customTags));
    }

    public void event(String name, long number, String ... customTags) {
        this.event_(name, number, Util.buildTags(customTags));
    }

    public void event(String name, Map<String, String> customTags) {
        this.event_(name, 1L, customTags);
    }

    public void event(String name, long number, Map<String, String> customTags) {
        this.event_(name, number, customTags);
    }

    private void event_(String name, long number, Map<String, String> customTags) {
        HashMap<String, String> ctags = new HashMap<String, String>();
        if (this.tags != null) {
            ctags.putAll(this.tags);
        }
        if (customTags != null) {
            ctags.putAll(customTags);
        }
        this.dispatchEvent(new LongEvent(this.prefix + name, ctags, System.currentTimeMillis(), number));
    }

    public EventImpl.Builder eventWithTags(String name) {
        return new EventImpl.Builder(name, this);
    }

    public void scheduleGauge(String name, int intervalInSeconds, Gauge<? extends Number> gauge, String ... tags) {
        this.scheduleGauge(name, intervalInSeconds, gauge, Util.buildTags(tags));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleGauge(String name, int intervalInSeconds, Gauge<? extends Number> gauge, Map<String, String> tags) {
        MetricKey key = new MetricKey(name, tags);
        if (!this.gauges.containsKey(key)) {
            Gauge<? extends Number> gauge2 = gauge;
            synchronized (gauge2) {
                if (!this.gauges.containsKey(key)) {
                    this.gauges.put(key, gauge);
                    this.pools.scheduleWithFixedDelay(new GaugeRunner<Number>(key, gauge, this), 0L, intervalInSeconds, TimeUnit.SECONDS);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener listener) {
        if (!this.listeners.contains(listener)) {
            List<EventListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        }
    }

    public void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllEventListeners() {
        this.listeners.clear();
    }

    void postEvent(String name, long ts, Map<String, String> customTags, Number number) {
        HashMap<String, String> ctags = new HashMap<String, String>();
        if (this.tags != null) {
            ctags.putAll(this.tags);
        }
        if (customTags != null) {
            ctags.putAll(customTags);
        }
        EventImpl e = number instanceof Double ? new DoubleEvent(this.prefix + name, ctags, ts, number.doubleValue()) : new LongEvent(this.prefix + name, ctags, ts, number.longValue());
        this.dispatchEvent(e);
    }

    void postEvent(String name, long ts, long value) {
        LongEvent e = new LongEvent(this.prefix + name, this.tags, ts, value);
        this.dispatchEvent(e);
    }

    void postEvent(String name, long ts, double value) {
        DoubleEvent e = new DoubleEvent(this.prefix + name, this.tags, ts, value);
        this.dispatchEvent(e);
    }

    void dispatchEvent(Event e) {
        this.listeners.stream().forEach(l -> l.onEvent(e));
    }

    public static class Builder {
        private Map<String, String> tags = new HashMap<String, String>();
        private final String prefix;

        public Builder(String applicationDomain, String application) {
            if (applicationDomain == null || application == null) {
                throw new IllegalArgumentException("applicationDomain and/or application cannot be null");
            }
            this.prefix = applicationDomain + "." + application + ".";
        }

        public Builder addTag(String tag, String value) {
            this.tags.put(tag, value);
            return this;
        }

        public MetricRegistry build() {
            if (this.tags.size() > 0) {
                return new MetricRegistry(this.prefix, this.tags);
            }
            return new MetricRegistry(this.prefix);
        }
    }
}

