/*
 * Decompiled with CFR 0.152.
 */
package org.dsh.metrics;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadMXBean;
import org.dsh.metrics.MetricRegistry;

public class JvmMetrics {
    public static void addMetrics(MetricRegistry registry, int intervalInSeconds) {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        registry.scheduleGauge("jvm.processCPU", intervalInSeconds, () -> osBean.getProcessCpuLoad(), new String[0]);
        registry.scheduleGauge("jvm.systemCPU", intervalInSeconds, () -> osBean.getSystemCpuLoad(), new String[0]);
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        registry.scheduleGauge("jvm.heapUsed", intervalInSeconds, () -> memoryBean.getHeapMemoryUsage().getUsed(), new String[0]);
        registry.scheduleGauge("jvm.nonHeapUsed", intervalInSeconds, () -> memoryBean.getNonHeapMemoryUsage().getUsed(), new String[0]);
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        registry.scheduleGauge("jvm.threads", intervalInSeconds, () -> threadBean.getThreadCount(), new String[0]);
    }
}

