/*
 * Decompiled with CFR 0.152.
 */
package org.dsh.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.dsh.metrics.Event;
import org.dsh.metrics.LongEvent;
import org.dsh.metrics.MetricRegistry;

public abstract class EventImpl
implements Event {
    private final String name;
    protected Map<String, String> tags;
    protected final long time;

    EventImpl(String name, Map<String, String> tags, long time) {
        this.name = name;
        this.tags = tags;
        this.time = time;
    }

    @Override
    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Override
    public long getTimestamp() {
        return this.time;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.time).append(" ").append(this.getName()).append(" ");
        if (this.tags != null) {
            for (Map.Entry<String, String> e : this.tags.entrySet()) {
                sb.append(e.getKey()).append("=").append(e.getValue());
                sb.append(",");
            }
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static class Builder {
        private MetricRegistry registry;
        EventImpl event;

        public Builder(String name, MetricRegistry registry) {
            this.registry = registry;
            this.event = new LongEvent(registry.getPrefix() + name, new HashMap<String, String>(), System.currentTimeMillis(), 1L);
        }

        public Builder addTag(String tag, String value) {
            this.event.tags.put(tag, value);
            return this;
        }

        public void build() {
            this.registry.dispatchEvent(this.event);
        }
    }
}

